/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.installations;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.rest.util.HttpBasicHelper;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;

@Stateless
@Path(value="/registry/device")
@TransactionAttribute
public class InstallationRegistrationEndpoint {
    private final Logger logger = Logger.getLogger(InstallationRegistrationEndpoint.class.getName());
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private GenericVariantService genericVariantService;

    @OPTIONS
    @Path(value="{token: .*}")
    public Response crossOriginForInstallations(@Context HttpHeaders headers, @PathParam(value="token") String token) {
        return this.appendPreflightResponseHeaders(headers, Response.ok()).build();
    }

    @OPTIONS
    public Response crossOriginForInstallations(@Context HttpHeaders headers) {
        return this.appendPreflightResponseHeaders(headers, Response.ok()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerInstallation(Installation entity, @Context HttpServletRequest request) {
        Variant variant = this.loadVariantWhenAuthorized(request);
        if (variant == null) {
            return this.appendAllowOriginHeader(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"AeroGear UnifiedPush Server\"").entity((Object)"Unauthorized Request"), request);
        }
        if (entity.getDeviceToken() == null) {
            return this.appendAllowOriginHeader(Response.status((Response.Status)Response.Status.BAD_REQUEST), request);
        }
        Installation installation = this.clientInstallationService.findInstallationForVariantByDeviceToken(variant.getVariantID(), entity.getDeviceToken());
        entity.setPlatform(variant.getType().getTypeName());
        this.logger.log(Level.FINEST, "Mobile Application on device was launched");
        if (installation == null) {
            this.logger.log(Level.FINEST, "Performing new device/client registration");
            this.clientInstallationService.addInstallation(variant, entity);
        } else if (installation.isEnabled()) {
            this.logger.log(Level.FINEST, "Updating received metadata for an 'enabled' installation");
            this.clientInstallationService.updateInstallation(installation, entity);
        }
        return this.appendAllowOriginHeader(Response.ok((Object)entity), request);
    }

    @DELETE
    @Path(value="{token: .*}")
    public Response unregisterInstallations(@PathParam(value="token") String token, @Context HttpServletRequest request) {
        Variant variant = this.loadVariantWhenAuthorized(request);
        if (variant == null) {
            return this.appendAllowOriginHeader(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"AeroGear UnifiedPush Server\"").entity((Object)"Unauthorized Request"), request);
        }
        Installation installation = this.clientInstallationService.findInstallationForVariantByDeviceToken(variant.getVariantID(), token);
        if (installation == null) {
            return this.appendAllowOriginHeader(Response.status((Response.Status)Response.Status.NOT_FOUND), request);
        }
        this.logger.log(Level.INFO, "Deleting metadata Installation");
        this.clientInstallationService.removeInstallation(installation);
        return this.appendAllowOriginHeader(Response.noContent(), request);
    }

    private Response.ResponseBuilder appendPreflightResponseHeaders(HttpHeaders headers, Response.ResponseBuilder response) {
        response.header("Access-Control-Allow-Origin", headers.getRequestHeader("Origin").get(0)).header("Access-Control-Allow-Methods", (Object)"POST, DELETE").header("Access-Control-Allow-Headers", (Object)"accept, origin, content-type, authorization").header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Max-Age", (Object)"604800");
        return response;
    }

    private Response appendAllowOriginHeader(Response.ResponseBuilder rb, HttpServletRequest request) {
        return rb.header("Access-Control-Allow-Origin", (Object)request.getHeader("Origin")).header("Access-Control-Allow-Credentials", (Object)"true").build();
    }

    private Variant loadVariantWhenAuthorized(HttpServletRequest request) {
        String[] credentials = HttpBasicHelper.extractUsernameAndPasswordFromBasicHeader(request);
        String variantID = credentials[0];
        String secret = credentials[1];
        Variant variant = this.genericVariantService.findByVariantID(variantID);
        if (variant != null && variant.getSecret().equals(secret)) {
            return variant;
        }
        return null;
    }
}

