/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.ejb.Stateless;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.AndroidVariant;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;

@Stateless
@Path(value="/applications/{pushAppID}/android")
public class AndroidVariantEndpoint
extends AbstractVariantEndpoint {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerAndroidVariant(AndroidVariant androidVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        try {
            this.validateModelClass(androidVariant);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        this.variantService.addVariant((Variant)androidVariant);
        this.pushAppService.addVariant(pushApp, (Variant)androidVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(androidVariant.getVariantID())).build(new Object[0])).entity((Object)androidVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllAndroidVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication application = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        return Response.ok(this.getVariantsByType(application, AndroidVariant.class)).build();
    }

    @PUT
    @Path(value="/{androidID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateAndroidVariation(@PathParam(value="pushAppID") String id, @PathParam(value="androidID") String androidID, AndroidVariant updatedAndroidApplication) {
        AndroidVariant androidVariant = (AndroidVariant)this.variantService.findByVariantID(androidID);
        if (androidVariant != null) {
            try {
                this.validateModelClass(updatedAndroidApplication);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            androidVariant.setGoogleKey(updatedAndroidApplication.getGoogleKey());
            androidVariant.setProjectNumber(updatedAndroidApplication.getProjectNumber());
            androidVariant.setName(updatedAndroidApplication.getName());
            androidVariant.setDescription(updatedAndroidApplication.getDescription());
            this.variantService.updateVariant((Variant)androidVariant);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

