/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.ChromePackagedAppVariant;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;

@Stateless
@Path(value="/applications/{pushAppID}/chrome")
public class ChromePackagedAppEndpoint
extends AbstractVariantEndpoint {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerChromePackagedAppVariant(ChromePackagedAppVariant chromePackagedAppVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        if (chromePackagedAppVariant.getClientSecret() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        chromePackagedAppVariant.setVariantID(UUID.randomUUID().toString());
        this.variantService.addVariant((Variant)chromePackagedAppVariant);
        this.pushAppService.addVariant(pushApp, (Variant)chromePackagedAppVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(chromePackagedAppVariant.getVariantID())).build(new Object[0])).entity((Object)chromePackagedAppVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllChromePackagedAppVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication application = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        return Response.ok(this.getVariantsByType(application, ChromePackagedAppVariant.class)).build();
    }

    @PUT
    @Path(value="/{chromeAppID}")
    @Consumes(value={"application/json"})
    public Response updateChromePackagedAppVariation(@PathParam(value="pushAppID") String id, @PathParam(value="chromeAppID") String chromeAppID, ChromePackagedAppVariant updatedChromePackagedApplication) {
        ChromePackagedAppVariant chromePackagedAppVariant = (ChromePackagedAppVariant)this.variantService.findByVariantID(chromeAppID);
        if (chromePackagedAppVariant != null) {
            if (updatedChromePackagedApplication.getClientSecret() == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            chromePackagedAppVariant.setClientId(updatedChromePackagedApplication.getClientId());
            chromePackagedAppVariant.setClientSecret(updatedChromePackagedApplication.getClientSecret());
            chromePackagedAppVariant.setRefreshToken(updatedChromePackagedApplication.getRefreshToken());
            chromePackagedAppVariant.setName(updatedChromePackagedApplication.getName());
            chromePackagedAppVariant.setDescription(updatedChromePackagedApplication.getDescription());
            this.variantService.updateVariant((Variant)chromePackagedAppVariant);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

