/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import java.util.Map;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.rest.AbstractBaseEndpoint;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;

@Stateless
@TransactionAttribute
@Path(value="/applications")
public class PushApplicationEndpoint
extends AbstractBaseEndpoint {
    private static final int MAX_PAGE_SIZE = 25;
    private static final int DEFAULT_PAGE_SIZE = 8;
    @Inject
    private PushApplicationService pushAppService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerPushApplication(PushApplication pushApp) {
        try {
            this.validateModelClass(pushApp);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        this.pushAppService.addPushApplication(pushApp);
        return Response.created((URI)UriBuilder.fromResource(PushApplicationEndpoint.class).path(String.valueOf(pushApp.getPushApplicationID())).build(new Object[0])).entity((Object)pushApp).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllPushApplications(@QueryParam(value="page") Integer page, @QueryParam(value="per_page") Integer pageSize) {
        pageSize = pageSize != null ? Integer.valueOf(Math.min(25, pageSize)) : Integer.valueOf(8);
        if (page == null) {
            page = 0;
        }
        PageResult pageResult = this.getSearch().findAllPushApplicationsForDeveloper(page, pageSize);
        return Response.ok((Object)pageResult.getResultList()).header("total", (Object)pageResult.getCount()).build();
    }

    @GET
    @Path(value="/{pushAppID}")
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp != null) {
            return Response.ok((Object)pushApp).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
    }

    @PUT
    @Path(value="/{pushAppID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePushApplication(@PathParam(value="pushAppID") String pushApplicationID, PushApplication updatedPushApp) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp != null) {
            try {
                this.validateModelClass(updatedPushApp);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            pushApp.setDescription(updatedPushApp.getDescription());
            pushApp.setName(updatedPushApp.getName());
            this.pushAppService.updatePushApplication(pushApp);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
    }

    @PUT
    @Path(value="/{pushAppID}/reset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetMasterSecret(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp != null) {
            String newMasterSecret = UUID.randomUUID().toString();
            pushApp.setMasterSecret(newMasterSecret);
            this.pushAppService.updatePushApplication(pushApp);
            return Response.ok((Object)pushApp).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
    }

    @DELETE
    @Path(value="/{pushAppID}")
    @Produces(value={"application/json"})
    public Response deletePushApplication(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp != null) {
            this.pushAppService.removePushApplication(pushApp);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
    }

    @GET
    @Path(value="/{pushAppID}/count")
    public Response countInstallations(@PathParam(value="pushAppID") String pushApplicationID) {
        Map result = this.pushAppService.countInstallationsByType(pushApplicationID);
        return Response.ok((Object)result).build();
    }
}

