/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import javax.servlet.http.HttpServletRequest;

public final class HttpRequestUtil {
    private HttpRequestUtil() {
    }

    public static Boolean extractSortingQueryParamValue(String sorting) {
        if (sorting != null && sorting.equalsIgnoreCase("desc")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static String extractIPAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (HttpRequestUtil.hasValue(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (HttpRequestUtil.hasValue(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (HttpRequestUtil.hasValue(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String extractAeroGearSenderInformation(HttpServletRequest request) {
        String client = request.getHeader("aerogear-sender");
        if (HttpRequestUtil.hasValue(client)) {
            return client;
        }
        return request.getHeader("user-agent");
    }

    private static boolean hasValue(String value) {
        return value != null && !value.isEmpty() && !"unknown".equalsIgnoreCase(value);
    }
}

