/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aerogear.unifiedpush.rest.util.transform.DynamicTransformer;

public class RequestTransformer {
    private final Logger logger = Logger.getLogger(RequestTransformer.class.getName());
    private static final String OPERATIONS = "operations";
    private static final String TRANSFORMER = "dynamicTransformer";

    public StringBuilder transform(String path, String version, StringBuilder json) {
        try {
            JsonNode node = this.locateJsonPatch(path, version);
            JsonNode operations = node.findPath(OPERATIONS);
            JsonNode patch = this.patchHasDynamicTransformer(operations) ? operations : node;
            JsonNode patched = this.transformJson(patch, json);
            return this.convertToStringBuilder(this.applyDynamicTransformer(patched, node));
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, String.format("could not find/load path file for version '%s' and path '%s'", version, path), e);
            return json;
        }
        catch (JsonPatchException e) {
            throw new RuntimeException("Error in json patch file", e);
        }
    }

    private boolean patchHasDynamicTransformer(JsonNode operations) {
        return !operations.isMissingNode();
    }

    private JsonNode locateJsonPatch(String path, String version) throws IOException {
        return JacksonUtils.getReader().readTree(this.getClass().getResourceAsStream(path + "/" + version + ".json"));
    }

    private JsonNode transformJson(JsonNode patch, StringBuilder json) throws IOException, JsonPatchException {
        JsonNode jsonNode = this.convertToJsonNode(json);
        for (JsonNode operation : patch) {
            try {
                ArrayNode nodes = JsonNodeFactory.instance.arrayNode();
                nodes.add(operation);
                JsonPatch patchOperation = JsonPatch.fromJson((JsonNode)nodes);
                jsonNode = patchOperation.apply(jsonNode);
            }
            catch (JsonPatchException e) {
                this.logger.log(Level.FINEST, "ignore field not found");
            }
        }
        return jsonNode;
    }

    private JsonNode convertToJsonNode(StringBuilder json) throws IOException {
        return JacksonUtils.getReader().readTree(json.toString());
    }

    private StringBuilder convertToStringBuilder(JsonNode dynamicTransformedNode) {
        return new StringBuilder(dynamicTransformedNode.toString());
    }

    JsonNode applyDynamicTransformer(JsonNode json, JsonNode patch) throws IOException {
        String clazz = patch.findPath(TRANSFORMER).textValue();
        if (clazz != null) {
            try {
                DynamicTransformer dynamicTransformer = (DynamicTransformer)Class.forName(this.getClass().getPackage().getName() + ".transform." + clazz).newInstance();
                return dynamicTransformer.transform(json);
            }
            catch (Exception e) {
                throw new RuntimeException("error in json patch could not instantiate / find dynamic transformer", e);
            }
        }
        return json;
    }
}

