/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.service.PushSearchService;
import org.jboss.aerogear.unifiedpush.service.impl.SearchManager;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

public abstract class AbstractBaseEndpoint {
    protected final AeroGearLogger logger = AeroGearLogger.getInstance(this.getClass());
    @Inject
    private Validator validator;
    @Inject
    private SearchManager searchManager;
    @Context
    private HttpServletRequest httpServletRequest;

    protected void validateModelClass(Object model) {
        Set violations = this.validator.validate(model, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(new HashSet(violations));
        }
    }

    protected Response.ResponseBuilder createBadRequestResponse(Set<ConstraintViolation<?>> violations) {
        HashMap<String, String> responseObj = new HashMap<String, String>();
        for (ConstraintViolation<?> violation : violations) {
            responseObj.put(violation.getPropertyPath().toString(), violation.getMessage());
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(responseObj);
    }

    protected PushSearchService getSearch() {
        return this.searchManager.getSearchService();
    }
}

