/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

public final class HttpRequestUtil {
    private HttpRequestUtil() {
    }

    public static Boolean extractSortingQueryParamValue(String sorting) {
        if ("desc".equalsIgnoreCase(sorting)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static String extractIPAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (HttpRequestUtil.isIPAdressValid(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (HttpRequestUtil.isIPAdressValid(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (HttpRequestUtil.isIPAdressValid(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String extractAeroGearSenderInformation(HttpServletRequest request) {
        String client = request.getHeader("aerogear-sender");
        if (HttpRequestUtil.hasValue(client)) {
            return client;
        }
        return request.getHeader("user-agent");
    }

    private static boolean isIPAdressValid(String ip) {
        if (HttpRequestUtil.hasValue(ip)) {
            try {
                InetAddress.getByName(ip);
                return true;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean hasValue(String value) {
        return value != null && !value.isEmpty();
    }
}

