/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jboss.aerogear.unifiedpush.rest.util.RequestTransformer;

@WebFilter(urlPatterns={"*"})
public class VersionFilter
implements Filter {
    private static final String AEROGEAR_VERSION_PREFIX = "aerogear.v";
    public static final int VERSION_LENGTH = 3;
    @Inject
    private RequestTransformer requestTransformer;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int index;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String accept = httpRequest.getHeader("accept");
        if (accept != null && (index = accept.indexOf(AEROGEAR_VERSION_PREFIX)) != -1) {
            int beginIndex = index + AEROGEAR_VERSION_PREFIX.length();
            String version = accept.substring(beginIndex, beginIndex + 3);
            chain.doFilter((ServletRequest)new TransformHttpServletRequestWrapper(version, httpRequest), response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private class TransformHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final StringBuilder jsonRequest;
        private final String path;
        private final String version;

        TransformHttpServletRequestWrapper(String version, HttpServletRequest httpRequest) throws IOException {
            super(httpRequest);
            this.jsonRequest = new StringBuilder();
            try (BufferedReader reader = httpRequest.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.jsonRequest.append(line);
                }
            }
            String contextPath = httpRequest.getContextPath();
            this.path = httpRequest.getRequestURI().substring(contextPath.length());
            this.version = version;
        }

        public ServletInputStream getInputStream() throws IOException {
            StringBuilder data = VersionFilter.this.requestTransformer.transform(this.path, this.version, this.jsonRequest);
            final byte[] bytes = data.toString().getBytes();
            return new ServletInputStream(){
                private InputStream inputStream;
                {
                    this.inputStream = new BufferedInputStream(new ByteArrayInputStream(bytes));
                }

                public int read() throws IOException {
                    return this.inputStream.read();
                }
            };
        }
    }
}

