/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import com.qmino.miredot.annotations.BodyType;
import com.qmino.miredot.annotations.ReturnType;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.aerogear.unifiedpush.api.AdmVariant;
import org.jboss.aerogear.unifiedpush.api.AndroidVariant;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.WindowsWNSVariant;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.jboss.aerogear.unifiedpush.rest.AbstractBaseEndpoint;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.PushApplicationEndpoint;
import org.jboss.aerogear.unifiedpush.rest.util.BootstrapForm;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

@Path(value="/applications/bootstrap")
public class BootstrapEndpoint
extends AbstractBaseEndpoint {
    @Inject
    private PushApplicationService pushAppService;
    @Inject
    protected GenericVariantService variantService;

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @BodyType(value="org.jboss.aerogear.unifiedpush.rest.util.BootstrapForm")
    @ReturnType(value="org.jboss.aerogear.unifiedpush.api.PushApplication")
    public Response registerPushApplicationAndVariants(@MultipartForm BootstrapForm form) {
        try {
            this.validateModelClass(form);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        PushApplication pushApplication = new PushApplication();
        pushApplication.setName(form.getPushApplicationName());
        this.pushAppService.addPushApplication(pushApplication);
        WindowsWNSVariant windowsVariant = null;
        if (form.getAndroidVariantName() != null) {
            AndroidVariant androidVariant = new AndroidVariant();
            androidVariant.setName(form.getAndroidVariantName());
            androidVariant.setGoogleKey(form.getAndroidGoogleKey());
            androidVariant.setProjectNumber(form.getAndroidProjectNumber());
            this.variantService.addVariant((Variant)androidVariant);
            this.pushAppService.addVariant(pushApplication, (Variant)androidVariant);
        }
        if (form.getiOSVariantName() != null) {
            iOSVariant iOSVariant2 = new iOSVariant();
            iOSVariant2.setName(form.getiOSVariantName());
            iOSVariant2.setPassphrase(form.getiOSPassphrase());
            iOSVariant2.setCertificate(form.getiOSCertificate());
            iOSVariant2.setProduction(form.getiOSProduction().booleanValue());
            this.variantService.addVariant((Variant)iOSVariant2);
            this.pushAppService.addVariant(pushApplication, (Variant)iOSVariant2);
        }
        if (form.getWindowsVariantName() != null) {
            WindowsWNSVariant wnsVariant = new WindowsWNSVariant();
            wnsVariant.setName(form.getWindowsVariantName());
            wnsVariant.setSid(form.getWindowsSid());
            wnsVariant.setClientSecret(form.getWindowsClientSecret());
            windowsVariant = wnsVariant;
            this.variantService.addVariant((Variant)windowsVariant);
            this.pushAppService.addVariant(pushApplication, (Variant)windowsVariant);
        }
        if (form.getAdmVariantName() != null) {
            AdmVariant admVariant = new AdmVariant();
            admVariant.setName(form.getAdmVariantName());
            admVariant.setClientId(form.getAdmClientId());
            admVariant.setClientSecret(form.getAdmClientSecret());
            this.variantService.addVariant((Variant)admVariant);
            this.pushAppService.addVariant(pushApplication, (Variant)admVariant);
        }
        return Response.created((URI)UriBuilder.fromResource(PushApplicationEndpoint.class).path(String.valueOf(pushApplication.getPushApplicationID())).build(new Object[0])).entity((Object)pushApplication).build();
    }
}

