/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.metrics;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dto.MessageMetrics;
import org.jboss.aerogear.unifiedpush.rest.util.CommonUtils;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;

@Path(value="/metrics/messages")
public class PushMetricsEndpoint {
    private static final int MAX_PAGE_SIZE = 100;
    private static final int DEFAULT_PAGE_SIZE = 25;
    @Inject
    private PushMessageMetricsService metricsService;

    @GET
    @Path(value="/application/{id}")
    @Produces(value={"application/json"})
    public Response pushMessageInformationPerApplication(@PathParam(value="id") String id, @QueryParam(value="page") Integer page, @QueryParam(value="per_page") Integer pageSize, @QueryParam(value="sort") String sorting, @QueryParam(value="search") String search) {
        pageSize = this.parsePageSize(pageSize);
        if (page == null) {
            page = 0;
        }
        if (id == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested information").build();
        }
        PageResult pageResult = this.metricsService.findAllFlatsForPushApplication(id, search, CommonUtils.isAscendingOrder(sorting).booleanValue(), page, pageSize);
        return Response.ok((Object)pageResult.getResultList()).header("total", (Object)((MessageMetrics)pageResult.getAggregate()).getCount()).header("receivers", (Object)"0").header("appOpenedCounter", (Object)((MessageMetrics)pageResult.getAggregate()).getAppOpenedCounter()).build();
    }

    private Integer parsePageSize(Integer pageSize) {
        pageSize = pageSize != null ? Integer.valueOf(Math.min(100, pageSize)) : Integer.valueOf(25);
        return pageSize;
    }
}

