/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.sender;

import io.prometheus.client.Counter;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.auth.HttpBasicHelper;
import org.jboss.aerogear.unifiedpush.message.InternalUnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.NotificationRouter;
import org.jboss.aerogear.unifiedpush.rest.util.HttpRequestUtil;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sender")
public class PushNotificationSenderEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(PushNotificationSenderEndpoint.class);
    private static final Counter promPushRequestsTotal = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("aerogear_ups_push_requests_total")).help("Total number of push requests.")).register();
    @Inject
    private PushApplicationService pushApplicationService;
    @Inject
    private NotificationRouter notificationRouter;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response send(InternalUnifiedPushMessage message, @Context HttpServletRequest request) {
        promPushRequestsTotal.inc();
        PushApplication pushApplication = this.loadPushApplicationWhenAuthorized(request);
        if (pushApplication == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"AeroGear UnifiedPush Server\"").entity((Object)"Unauthorized Request").build();
        }
        message.setIpAddress(HttpRequestUtil.extractIPAddress(request));
        message.setClientIdentifier(HttpRequestUtil.extractAeroGearSenderInformation(request));
        this.notificationRouter.submit(pushApplication, message);
        logger.debug("Push Message Request from [{}] API was internally submitted for further processing", (Object)message.getClientIdentifier());
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)"{}").build();
    }

    private PushApplication loadPushApplicationWhenAuthorized(HttpServletRequest request) {
        String[] credentials = HttpBasicHelper.extractUsernameAndPasswordFromBasicHeader((HttpServletRequest)request);
        String pushApplicationID = credentials[0];
        String secret = credentials[1];
        PushApplication pushApplication = this.pushApplicationService.findByPushApplicationID(pushApplicationID);
        if (pushApplication != null && pushApplication.getMasterSecret().equals(secret)) {
            return pushApplication;
        }
        return null;
    }
}

