/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.rest.util.CommonUtils;
import org.jboss.aerogear.unifiedpush.system.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/auth/config")
public class KeycloakConfigurationEndpoint {
    private static final String REALM_NAME_PROPERTY = "ups.realm.name";
    private static final String REALM_URL_PROPERTY = "ups.auth.server.url";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(KeycloakConfigurationEndpoint.class);

    @GET
    @Produces(value={"application/json"})
    public Response configurationFile() throws JsonProcessingException {
        String realmName = ConfigurationUtils.tryGetGlobalProperty((String)REALM_NAME_PROPERTY);
        String keycloakServerURL = CommonUtils.removeDefaultHttpPorts(ConfigurationUtils.tryGetGlobalProperty((String)REALM_URL_PROPERTY));
        Config config = new Config(realmName, keycloakServerURL);
        logger.trace("rendering '{}' realm config, for {}", (Object)realmName, (Object)keycloakServerURL);
        return Response.ok((Object)mapper.writeValueAsString((Object)config)).build();
    }

    private class Config {
        private String realm = "aerogear";
        @JsonProperty(value="auth-server-url")
        private String authServerUrl = "/auth";
        @JsonProperty(value="ssl-required")
        private final String sslRequired = "external";
        @JsonProperty(value="public-client")
        private final boolean publicClient = true;
        @JsonProperty(value="auth-enabled")
        private boolean authEnabled = false;
        private final String resource = "unified-push-server-js";

        public Config(String realmName, String authServerUrl) {
            if (realmName != null && !this.realm.isEmpty()) {
                this.realm = realmName;
            }
            if (authServerUrl != null && !authServerUrl.isEmpty()) {
                logger.trace("UPS is protected by an authentification broker");
                this.authServerUrl = authServerUrl;
                this.authEnabled = true;
            }
        }

        public String getRealm() {
            return this.realm;
        }

        public String getAuthServerUrl() {
            return this.authServerUrl;
        }

        public String getSslRequired() {
            return "external";
        }

        public String getResource() {
            return "unified-push-server-js";
        }

        public boolean isPublicClient() {
            return true;
        }

        public boolean isAuthEnabled() {
            return this.authEnabled;
        }
    }
}

