/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.api.validation;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.api.validation.DeviceTokenCheck;

public class DeviceTokenValidator
implements ConstraintValidator<DeviceTokenCheck, Installation> {
    private static final Pattern IOS_DEVICE_TOKEN = Pattern.compile("(?i)[a-f0-9 -]{64,}");
    private static final Pattern ANDROID_DEVICE_TOKEN = Pattern.compile("(?i)[0-9a-z\\-_]{100,}");

    public void initialize(DeviceTokenCheck constraintAnnotation) {
    }

    public boolean isValid(Installation installation, ConstraintValidatorContext context) {
        String deviceToken = installation.getDeviceToken();
        if (installation.getVariant() == null || installation.getVariant().getType() == null || deviceToken == null) {
            return true;
        }
        VariantType type = installation.getVariant().getType();
        switch (type) {
            case IOS: {
                return IOS_DEVICE_TOKEN.matcher(deviceToken).matches();
            }
            case ANDROID: {
                return ANDROID_DEVICE_TOKEN.matcher(deviceToken).matches();
            }
        }
        return true;
    }
}

