/**
 * JBoss, Home of Professional Open Source
 * Copyright Red Hat, Inc., and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.aerogear.unifiedpush.dao;

import org.jboss.aerogear.unifiedpush.api.PushApplication;

import java.util.List;
import java.util.Map;

public interface PushApplicationDao extends GenericBaseDao<PushApplication, String> {

    /**
     * Finder that returns all pushApplication object for the given owner/developer.
     */
    PageResult<PushApplication> findAllForDeveloper(String loginName, Integer page, Integer pageSize);

    /**
     * Finder that returns a list, containing all pushApplication ids for the given owner/developer.
     */
    List<String> findAllPushApplicationIDsForDeveloper(String loginName);

    /**
     * Finder that returns an actual PushApplicationEntity, identified by its ID and its owner/developer.
     */
    PushApplication findByPushApplicationIDForDeveloper(String pushApplicationID, String loginName);

    /**
     * Finder that returns an actual PushApplicationEntity, identified by its ID.
     */
    PushApplication findByPushApplicationID(String pushApplicationID);

    Map<String, Long> countInstallationsByType(String pushApplicationID);

    /**
     * Returns total number of PushApplications for given user
     */
    long getNumberOfPushApplicationsForDeveloper(String name);

    /**
     * Return application name and id of all variants matching given ids
     */
    List<PushApplication> findByVariantIds(List<String> variantIDs);

    //Admin queries
    /**
     * Finder that returns an actual PushApplicationEntity, identified by its ID and its owner/developer.
     */
    PushApplication findAllByPushApplicationID(String pushApplicationID);

    PageResult<PushApplication> findAll(Integer page, Integer pageSize);

    long getNumberOfPushApplicationsForDeveloper();
}
