/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.utils;

import java.util.logging.Level;
import java.util.logging.Logger;

public class AeroGearLogger {
    private static Logger logger;

    private AeroGearLogger() {
    }

    public static AeroGearLogger getInstance(Class clazz) {
        logger = Logger.getLogger(clazz.getSimpleName());
        return SingletonHolder.instance;
    }

    public void info(String message) {
        logger.info(this.format(message));
    }

    public void warning(String message) {
        logger.log(Level.WARNING, this.format(message));
    }

    public void severe(String message) {
        logger.log(Level.SEVERE, this.format(message));
    }

    public void severe(String message, Throwable t) {
        logger.log(Level.SEVERE, this.format(message), t);
    }

    public void fine(String message) {
        logger.log(Level.FINE, this.format(message));
    }

    public void finest(String message) {
        logger.log(Level.FINEST, this.format(message));
    }

    private String format(String logMessage) {
        StringBuilder message = new StringBuilder(logMessage);
        StringBuilder str = new StringBuilder();
        block10: for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            switch (c) {
                case '\r': {
                    str.append("\\r");
                    continue block10;
                }
                case '\n': {
                    str.append("\\n");
                    continue block10;
                }
                case '&': {
                    str.append("&amp;");
                    continue block10;
                }
                case '<': {
                    str.append("&lt;");
                    continue block10;
                }
                case '>': {
                    str.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block10;
                }
                case '/': {
                    str.append("&#x2F;");
                    continue block10;
                }
                default: {
                    str.append(c);
                }
            }
        }
        return str.toString();
    }

    private static final class SingletonHolder {
        private static final AeroGearLogger instance = new AeroGearLogger();

        private SingletonHolder() {
        }
    }
}

