/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.api;

import java.io.IOException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import net.iharder.Base64;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;

public class iOSVariant
extends Variant {
    private static final long serialVersionUID = -889367404039436329L;
    private boolean production = false;
    @NotNull
    @Size(max=255, message="Passphrase must be 1-255 characters long")
    @JsonIgnore
    private String passphrase;
    @NotNull(message="Certificate must be provided")
    @JsonIgnore
    private String certificateData;

    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    @JsonIgnore
    public String getPassphrase() {
        return this.passphrase;
    }

    @JsonProperty
    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @JsonIgnore
    public byte[] getCertificate() {
        try {
            return Base64.decode((String)this.certificateData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonProperty
    public void setCertificate(byte[] cert) {
        this.certificateData = Base64.encodeBytes((byte[])cert);
    }

    @Override
    public VariantType getType() {
        return VariantType.IOS;
    }
}

