/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.utils;

import java.util.logging.Level;
import java.util.logging.Logger;

public class AeroGearLogger {
    private Logger logger;

    private AeroGearLogger(Logger logger) {
        this.logger = logger;
    }

    public static AeroGearLogger getInstance(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class required");
        }
        String name = clazz.getName();
        return AeroGearLogger.getInstance(name);
    }

    private static AeroGearLogger getInstance(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name required");
        }
        Logger log = Logger.getLogger(name);
        return new AeroGearLogger(log);
    }

    public void info(String message) {
        this.logger.info(this.format(message));
    }

    public void warning(String message) {
        this.logger.log(Level.WARNING, this.format(message));
    }

    public void severe(String message) {
        this.logger.log(Level.SEVERE, this.format(message));
    }

    public void severe(String message, Throwable t) {
        this.logger.log(Level.SEVERE, this.format(message), t);
    }

    public void fine(String message) {
        this.logger.log(Level.FINE, this.format(message));
    }

    public void finest(String message) {
        this.logger.log(Level.FINEST, this.format(message));
    }

    private String format(String logMessage) {
        StringBuilder message = new StringBuilder(logMessage);
        StringBuilder str = new StringBuilder();
        block10: for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            switch (c) {
                case '\r': {
                    str.append("\\r");
                    continue block10;
                }
                case '\n': {
                    str.append("\\n");
                    continue block10;
                }
                case '&': {
                    str.append("&amp;");
                    continue block10;
                }
                case '<': {
                    str.append("&lt;");
                    continue block10;
                }
                case '>': {
                    str.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block10;
                }
                case '/': {
                    str.append("&#x2F;");
                    continue block10;
                }
                default: {
                    str.append(c);
                }
            }
        }
        return str.toString();
    }
}

