/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import nl.martijndwars.webpush.Utils;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.utils.KeyUtils;

public class WebPushVariant
extends Variant {
    private static final long serialVersionUID = -1873585264296190331L;
    @NotNull
    @Size(min=1, max=255, message="Public Key must be max. 255 chars long")
    private String publicKey;
    @NotNull
    @Size(max=255, message="Private Key must be max. 255 chars long")
    private String privateKey;
    @NotNull
    @Size(max=255, message="Alias Must be a max of 255 Chars")
    private String alias;

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public VariantType getType() {
        return VariantType.WEB_PUSH;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @AssertTrue(message="the provided private key does not match with the public key")
    @JsonIgnore
    public boolean isKeypairValid() {
        try {
            PrivateKey privateKeyObject = KeyUtils.loadPrivateKey(this.getPrivateKey());
            PublicKey publicKeyObject = KeyUtils.loadPublicKey(this.getPublicKey());
            return Utils.verifyKeyPair((PrivateKey)privateKeyObject, (PublicKey)publicKeyObject);
        }
        catch (Exception e) {
            return false;
        }
    }

    @AssertTrue(message="Alias must be a url or mailto")
    @JsonIgnore
    public boolean isAliasURLorMailto() {
        block5: {
            if (this.alias != null && !this.alias.isEmpty()) break block5;
            return false;
        }
        try {
            if (this.alias.toLowerCase().startsWith("mailto:")) {
                return this.alias.contains("@");
            }
            new URL(this.alias);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

