/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jboss.aerogear.unifiedpush.api.APNSVariant;
import org.jboss.aerogear.unifiedpush.api.VariantType;

public class iOSTokenVariant
extends APNSVariant {
    private static final long serialVersionUID = -889367404039436329L;
    @NotNull
    @Size(max=10, min=10, message="Team ID must be 10 characters long")
    private String teamId;
    @NotNull
    @Size(max=10, min=10, message="Key ID must be 10 characters long")
    private String keyId;
    @NotNull(message="Private key must be provided in p8 format")
    @JsonIgnore
    private String privateKey;
    @NotNull(message="Bundle ID is required.")
    private String bundleId;

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    @JsonIgnore
    public String getPrivateKey() {
        return this.privateKey;
    }

    @JsonProperty
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public VariantType getType() {
        return VariantType.IOS_TOKEN;
    }

    @AssertTrue(message="the provided private key must be in p8 format")
    @JsonIgnore
    public boolean isTokenValid() {
        try {
            ByteArrayInputStream targetStream = new ByteArrayInputStream(this.privateKey.getBytes());
            ApnsSigningKey.loadFromInputStream((InputStream)targetStream, (String)this.teamId, (String)this.keyId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }
}

