/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Base64;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jboss.aerogear.unifiedpush.api.APNSVariant;
import org.jboss.aerogear.unifiedpush.api.VariantType;

public class iOSVariant
extends APNSVariant {
    private static final long serialVersionUID = -889367404039436329L;
    @NotNull
    @Size(max=255, message="Passphrase must be 1-255 characters long")
    @JsonIgnore
    private String passphrase;
    @NotNull(message="Certificate must be provided")
    @JsonIgnore
    private String certificateData;

    @JsonIgnore
    public String getPassphrase() {
        return this.passphrase;
    }

    @JsonProperty
    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @JsonIgnore
    public byte[] getCertificate() {
        return Base64.getDecoder().decode(this.certificateData);
    }

    @JsonProperty
    public void setCertificate(byte[] cert) {
        this.certificateData = Base64.getEncoder().encodeToString(cert);
    }

    @Override
    public VariantType getType() {
        return VariantType.IOS;
    }
}

