/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.api.validation;

import com.google.gson.Gson;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.api.WebPushRegistration;
import org.jboss.aerogear.unifiedpush.api.validation.DeviceTokenCheck;

public class DeviceTokenValidator
implements ConstraintValidator<DeviceTokenCheck, Installation> {
    private static final Pattern IOS_DEVICE_TOKEN = Pattern.compile("(?i)[a-f0-9 -]{64,}");
    private static final Pattern ANDROID_DEVICE_TOKEN = Pattern.compile("(?i)[0-9a-z\\-_:]{100,}");

    public void initialize(DeviceTokenCheck constraintAnnotation) {
    }

    public boolean isValid(Installation installation, ConstraintValidatorContext context) {
        String deviceToken = installation.getDeviceToken();
        if (installation.getVariant() == null || installation.getVariant().getType() == null || deviceToken == null) {
            return false;
        }
        VariantType type = installation.getVariant().getType();
        return DeviceTokenValidator.isValidDeviceTokenForVariant(deviceToken, type);
    }

    public static boolean isValidDeviceTokenForVariant(String deviceToken, VariantType type) {
        switch (type) {
            case IOS: 
            case IOS_TOKEN: {
                return IOS_DEVICE_TOKEN.matcher(deviceToken).matches();
            }
            case ANDROID: {
                return ANDROID_DEVICE_TOKEN.matcher(deviceToken).matches();
            }
            case WEB_PUSH: {
                return DeviceTokenValidator.isWebPushRegistration(deviceToken);
            }
        }
        return false;
    }

    private static boolean isWebPushRegistration(String deviceToken) {
        try {
            String jsonToken = new String(Base64.getDecoder().decode(deviceToken));
            Gson gson = new Gson();
            WebPushRegistration registration = (WebPushRegistration)gson.fromJson(jsonToken, WebPushRegistration.class);
            return !registration.getEndpoint().isEmpty() && !registration.getKeys().getAuth().isEmpty() && !registration.getKeys().getP256dh().isEmpty();
        }
        catch (Exception ignore) {
            return false;
        }
    }
}

