/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.utils;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import nl.martijndwars.webpush.Base64Encoder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.jboss.aerogear.unifiedpush.api.WebPushRegistration;

public class KeyUtils {
    private static final String CURVE = "prime256v1";
    private static final String ALGORITHM = "ECDH";
    private static final Provider PROVIDER = new BouncyCastleProvider();

    public static PrivateKey loadPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decodedPrivateKey = Base64Encoder.decode((String)privateKey);
        BigInteger s = BigIntegers.fromUnsignedByteArray((byte[])decodedPrivateKey);
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(s, (ECParameterSpec)parameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, PROVIDER);
        return keyFactory.generatePrivate((KeySpec)privateKeySpec);
    }

    public static PublicKey loadPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decodedPublicKey = Base64Encoder.decode((String)publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, PROVIDER);
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECCurve curve = parameterSpec.getCurve();
        ECPoint point = curve.decodePoint(decodedPublicKey);
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)parameterSpec);
        return keyFactory.generatePublic((KeySpec)pubSpec);
    }

    public static PublicKey getUserPublicKey(WebPushRegistration registration) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance(ALGORITHM, PROVIDER);
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        ECPoint point = ecSpec.getCurve().decodePoint(registration.getKeyAsBytes());
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
        return kf.generatePublic((KeySpec)pubSpec);
    }
}

