/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Collections;
import java.util.List;
import javax.persistence.Query;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.VariantDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAVariantDao
extends JPABaseDao
implements VariantDao {
    public void create(Variant variant) {
        this.persist(variant);
    }

    public void update(Variant variant) {
        this.merge(variant);
    }

    public void delete(Variant variant) {
        this.entityManager.createQuery("delete from Installation i where i.variant = :variant").setParameter("variant", (Object)variant).executeUpdate();
        Variant entity = (Variant)this.entityManager.find(Variant.class, (Object)variant.getId());
        this.remove(entity);
    }

    public Variant findByVariantID(String variantID) {
        Variant entity = this.getSingleResultForQuery(this.createQuery("select t from Variant t where t.variantID = :variantID").setParameter("variantID", (Object)variantID));
        return entity;
    }

    public Variant findByVariantIDForDeveloper(String variantID, String loginName) {
        Variant entity = this.getSingleResultForQuery(this.createQuery("select t from Variant t where t.variantID = :variantID and t.developer = :developer").setParameter("variantID", (Object)variantID).setParameter("developer", (Object)loginName));
        return entity;
    }

    public boolean existsVariantIDForDeveloper(String variantID, String loginName) {
        Long numberOfVariants = (Long)this.createQuery("select count(t) from Variant t where t.variantID = :variantID and t.developer = :developer").setParameter("variantID", (Object)variantID).setParameter("developer", (Object)loginName).getSingleResult();
        return numberOfVariants == 1L;
    }

    public List<String> findVariantIDsForDeveloper(String loginName) {
        return this.createQuery("select t.variantID from Variant t where t.developer = :developer").setParameter("developer", (Object)loginName).getResultList();
    }

    public List<Variant> findAllVariantsByIDs(List<String> variantIDs) {
        if (variantIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createQuery("select t from Variant t where t.variantID IN :variantIDs").setParameter("variantIDs", variantIDs).getResultList();
    }

    public Variant find(String id) {
        Variant entity = (Variant)this.entityManager.find(Variant.class, (Object)id);
        return entity;
    }

    private Variant getSingleResultForQuery(Query query) {
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (Variant)result.get(0);
        }
        return null;
    }
}

