/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAPushMessageInformationDao
extends JPABaseDao
implements PushMessageInformationDao {
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private final Logger logger = Logger.getLogger(JPAPushMessageInformationDao.class.getName());

    public List<PushMessageInformation> findAllForPushApplication(String pushApplicationId, boolean ascending) {
        List messageInformations = this.createQuery("select pmi from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending)).setParameter("pushApplicationId", (Object)pushApplicationId).getResultList();
        return messageInformations;
    }

    public PageResult<PushMessageInformation> findAllForPushApplication(String pushApplicationId, boolean ascending, Integer page, Integer pageSize) {
        String query = "select pmi from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending);
        String countQuery = "select count(*) from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId";
        return this.executePagedQuery(pushApplicationId, "pushApplicationId", page, pageSize, query, "select count(*) from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId");
    }

    public PageResult<PushMessageInformation> findAllForVariant(String variantID, boolean ascending, Integer page, Integer pageSize) {
        String query = "select pmi from PushMessageInformation pmi JOIN fetch pmi.variantInformations vi where vi.variantID = :variantID ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending);
        String countQuery = "select count(*) from PushMessageInformation pmi JOIN pmi.variantInformations vi where vi.variantID = :variantID";
        return this.executePagedQuery(variantID, "variantID", page, pageSize, query, "select count(*) from PushMessageInformation pmi JOIN pmi.variantInformations vi where vi.variantID = :variantID");
    }

    private PageResult<PushMessageInformation> executePagedQuery(String param, String paramName, Integer page, Integer pageSize, String query, String countQuery) {
        List pushMessageInformationList = this.createQuery(query).setParameter(paramName, (Object)param).setFirstResult(page * pageSize).setMaxResults(pageSize.intValue()).getResultList();
        Long count = (Long)this.createQuery(countQuery).setParameter(paramName, (Object)param).getSingleResult();
        return new PageResult(pushMessageInformationList, count.longValue());
    }

    public long getNumberOfPushMessagesForApplications(String loginName) {
        return (Long)this.createQuery("select count(pmi) from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p where p.developer = :developer)").setParameter("developer", (Object)loginName).getSingleResult();
    }

    public PushMessageInformation find(String id) {
        return (PushMessageInformation)this.entityManager.find(PushMessageInformation.class, (Object)id);
    }

    public void create(PushMessageInformation pushMessageInformation) {
        this.persist(pushMessageInformation);
    }

    public void update(PushMessageInformation pushMessageInformation) {
        this.merge(pushMessageInformation);
    }

    public void delete(PushMessageInformation pushMessageInformation) {
        PushMessageInformation entity = this.find(pushMessageInformation.getId());
        this.remove(entity);
    }

    public List<String> findVariantIDsWithWarnings(String loginName) {
        List variantIDsWithWarnings = this.createQuery("select distinct vmi.variantID from VariantMetricInformation vmi where vmi.variantID IN (select t.variantID from Variant t where t.developer = :developer) and vmi.deliveryStatus = false").setParameter("developer", (Object)loginName).getResultList();
        return variantIDsWithWarnings;
    }

    public List<PushMessageInformation> findLastThreeActivity(String loginName) {
        List topThree = this.createQuery("select pmi from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p where p.developer = :developer) ORDER BY pmi.submitDate DESC").setParameter("developer", (Object)loginName).setMaxResults(3).getResultList();
        return topThree;
    }

    public void deletePushInformationOlderThan(Date oldest) {
        List oldMessages = this.createQuery("select pmi FROM PushMessageInformation pmi WHERE pmi.submitDate < :oldest").setParameter("oldest", (Object)oldest).getResultList();
        this.logger.log(Level.INFO, "Deleting ['" + oldMessages.size() + "'] outdated PushMessageInformation objects");
        for (PushMessageInformation oldMessage : oldMessages) {
            this.remove(oldMessage);
        }
    }

    private String ascendingOrDescending(boolean asc) {
        if (asc) {
            return ASC;
        }
        return DESC;
    }
}

