/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.Session;
import org.jboss.aerogear.unifiedpush.dao.GenericBaseDao;

public abstract class JPABaseDao<T, K>
implements GenericBaseDao<T, K> {
    @Inject
    protected EntityManager entityManager;

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected TypedQuery<T> createQuery(String jpql) {
        return this.entityManager.createQuery(jpql, this.getType());
    }

    protected Query createUntypedQuery(String jpql) {
        return this.entityManager.createQuery(jpql);
    }

    protected <O> TypedQuery<O> createQuery(String jpql, Class<O> type) {
        return this.entityManager.createQuery(jpql, type);
    }

    protected org.hibernate.Query createHibernateQuery(String hql) {
        Session session = (Session)this.entityManager.getDelegate();
        return session.createQuery(hql);
    }

    public abstract Class<T> getType();

    public T find(K id) {
        return (T)this.entityManager.find(this.getType(), id);
    }

    public void create(T entity) {
        this.entityManager.persist(entity);
    }

    public void update(T entity) {
        this.entityManager.merge(entity);
        this.entityManager.flush();
    }

    public T refresh(T entity) {
        if (!this.entityManager.contains(entity)) {
            entity = this.entityManager.merge(entity);
        }
        this.entityManager.refresh(entity);
        return entity;
    }

    public void lock(T entity) {
        this.entityManager.lock(entity, LockModeType.PESSIMISTIC_WRITE);
    }

    public void delete(T entity) {
        if (entity != null) {
            if (!this.entityManager.contains(entity)) {
                entity = this.entityManager.merge(entity);
            }
            this.entityManager.remove(entity);
        }
    }

    public void flushAndClear() {
        this.entityManager.flush();
        this.entityManager.clear();
    }

    protected T getSingleResultForQuery(TypedQuery<T> query) {
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (T)result.get(0);
        }
        return null;
    }
}

