/**
 * JBoss, Home of Professional Open Source
 * Copyright Red Hat, Inc., and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.aerogear.unifiedpush.utils;

import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/**
 * Creates the arquillian deployment for this module
 */
public class DaoDeployment {

    public static JavaArchive createDeployment() {
        return ShrinkWrap.create(JavaArchive.class)
                .addPackage("org.jboss.aerogear.unifiedpush.jpa.dao.impl")
                .addPackage("org.jboss.aerogear.unifiedpush.api")
                .addPackage("org.jboss.aerogear.unifiedpush.api.dao")
                .addAsManifestResource(EmptyAsset.INSTANCE, "beans.xml")
                .addClass(EntityFactory.class)
                .addAsManifestResource("META-INF/persistence.xml");
    }
}
