/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.jms.Queue;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.message.event.PushMessageCompletedEvent;
import org.jboss.aerogear.unifiedpush.message.event.VariantCompletedEvent;
import org.jboss.aerogear.unifiedpush.message.jms.AbstractJMSMessageConsumer;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@Stateless
public class MetricsCollector
extends AbstractJMSMessageConsumer {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(MetricsCollector.class);
    @Inject
    private PushMessageMetricsService metricsService;
    @Resource(mappedName="java:/queue/BatchLoadedQueue")
    private Queue batchLoadedQueue;
    @Resource(mappedName="java:/queue/AllBatchesLoadedQueue")
    private Queue allBatchesLoaded;
    @Inject
    private Event<VariantCompletedEvent> variantCompleted;
    @Inject
    private Event<PushMessageCompletedEvent> pushMessageCompleted;

    public void collectMetrics(@Observes @Dequeue VariantMetricInformation variantMetricInformation) {
        PushMessageInformation pushMessageInformation = this.metricsService.getPushMessageInformation(variantMetricInformation.getPushMessageInformation().getId());
        this.metricsService.lock(pushMessageInformation);
        String variantID = variantMetricInformation.getVariantID();
        pushMessageInformation.setTotalReceivers(pushMessageInformation.getTotalReceivers() + variantMetricInformation.getReceivers());
        int loadedBatches = this.countLoadedBatches(variantID);
        variantMetricInformation.setTotalBatches(variantMetricInformation.getTotalBatches() + loadedBatches);
        boolean updatedExisting = false;
        for (VariantMetricInformation existingMetric : pushMessageInformation.getVariantInformations()) {
            if (!variantMetricInformation.getVariantID().equals(existingMetric.getVariantID())) continue;
            updatedExisting = true;
            this.updateExistingMetric(existingMetric, variantMetricInformation);
            variantMetricInformation = existingMetric;
            break;
        }
        if (!updatedExisting) {
            pushMessageInformation.addVariantInformations(variantMetricInformation);
        }
        this.metricsService.updatePushMessageInformation(pushMessageInformation);
        if (variantMetricInformation.getTotalBatches() == variantMetricInformation.getServedBatches() && this.areAllBatchesLoaded(variantID)) {
            pushMessageInformation.setServedVariants(pushMessageInformation.getServedVariants() + 1);
            this.logger.fine(String.format("All batches for variant %s were processed", variantMetricInformation.getVariantID()));
            this.variantCompleted.fire((Object)new VariantCompletedEvent(pushMessageInformation.getId(), variantMetricInformation.getVariantID()));
            if (pushMessageInformation.getServedVariants() == pushMessageInformation.getTotalVariants()) {
                this.logger.fine(String.format("All batches for application %s were processed", pushMessageInformation.getId()));
                this.pushMessageCompleted.fire((Object)new PushMessageCompletedEvent(pushMessageInformation.getId()));
            }
        }
    }

    private int countLoadedBatches(String variantID) {
        int loadedBatches = 0;
        while (this.receiveInTransactionNoWait(this.batchLoadedQueue, "variantID", variantID) != null) {
            ++loadedBatches;
        }
        return loadedBatches;
    }

    private boolean areAllBatchesLoaded(String variantID) {
        return this.receiveInTransactionNoWait(this.allBatchesLoaded, "variantID", variantID) != null;
    }

    private void updateExistingMetric(VariantMetricInformation existing, VariantMetricInformation update) {
        existing.setReceivers(existing.getReceivers() + update.getReceivers());
        existing.setServedBatches(existing.getServedBatches() + update.getServedBatches());
        existing.setTotalBatches(existing.getTotalBatches() + update.getTotalBatches());
        if (existing.getDeliveryStatus() == null) {
            existing.setDeliveryStatus(update.getDeliveryStatus());
        }
        if (existing.getDeliveryStatus() == Boolean.TRUE && update.getDeliveryStatus() == Boolean.FALSE) {
            existing.setDeliveryStatus(Boolean.FALSE);
        }
        if (existing.getReason() == null && update.getReason() != null) {
            existing.setReason(update.getReason());
        }
    }
}

