/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderTypeLiteral;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@Stateless
public class NotificationDispatcher {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(NotificationDispatcher.class);
    @Inject
    @Any
    private Instance<PushNotificationSender> senders;
    @Inject
    @DispatchToQueue
    private Event<VariantMetricInformation> dispatchVariantMetricEvent;

    public void sendMessagesToPushNetwork(@Observes @Dequeue MessageHolderWithTokens msg) {
        Variant variant = msg.getVariant();
        UnifiedPushMessage message = msg.getUnifiedPushMessage();
        Collection<String> deviceTokens = msg.getDeviceTokens();
        this.logger.fine("Received message from queue: " + msg.getUnifiedPushMessage().getMessage().getAlert());
        ((PushNotificationSender)this.senders.select(new Annotation[]{new SenderTypeLiteral(variant.getType())}).get()).sendPushMessage(variant, deviceTokens, message, msg.getPushMessageInformation().getId(), new SenderServiceCallback(variant, deviceTokens.size(), msg.getPushMessageInformation()));
    }

    private void updateStatusOfPushMessageInformation(PushMessageInformation pushMessageInformation, String variantID, int receivers, Boolean deliveryStatus) {
        this.updateStatusOfPushMessageInformation(pushMessageInformation, variantID, receivers, deliveryStatus, null);
    }

    private void updateStatusOfPushMessageInformation(PushMessageInformation pushMessageInformation, String variantID, int receivers, Boolean deliveryStatus, String reason) {
        VariantMetricInformation variantMetricInformation = new VariantMetricInformation();
        variantMetricInformation.setPushMessageInformation(pushMessageInformation);
        variantMetricInformation.setVariantID(variantID);
        variantMetricInformation.setReceivers((long)receivers);
        variantMetricInformation.setDeliveryStatus(deliveryStatus);
        variantMetricInformation.setReason(reason);
        variantMetricInformation.setServedBatches(1);
        this.dispatchVariantMetricEvent.fire((Object)variantMetricInformation);
    }

    private class SenderServiceCallback
    implements NotificationSenderCallback {
        private final Variant variant;
        private final int tokenSize;
        private final PushMessageInformation pushMessageInformation;

        public SenderServiceCallback(Variant variant, int tokenSize, PushMessageInformation pushMessageInformation) {
            this.variant = variant;
            this.tokenSize = tokenSize;
            this.pushMessageInformation = pushMessageInformation;
        }

        @Override
        public void onSuccess() {
            NotificationDispatcher.this.logger.fine(String.format("Sent '%s' message to '%d' devices", this.variant.getType().getTypeName(), this.tokenSize));
            NotificationDispatcher.this.updateStatusOfPushMessageInformation(this.pushMessageInformation, this.variant.getVariantID(), this.tokenSize, Boolean.TRUE);
        }

        @Override
        public void onError(String reason) {
            NotificationDispatcher.this.logger.warning(String.format("Error on '%s' delivery", this.variant.getType().getTypeName()));
            NotificationDispatcher.this.updateStatusOfPushMessageInformation(this.pushMessageInformation, this.variant.getVariantID(), this.tokenSize, Boolean.FALSE, reason);
        }
    }
}

