/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.InternalUnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithVariants;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@Stateless
public class NotificationRouter {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(NotificationRouter.class);
    @Inject
    private GenericVariantService genericVariantService;
    @Inject
    private PushMessageMetricsService metricsService;
    @Inject
    @DispatchToQueue
    private Event<MessageHolderWithVariants> dispatchVariantMessageEvent;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void submit(PushApplication pushApplication, InternalUnifiedPushMessage message) {
        this.logger.info("Processing send request with '" + message.toString() + "' payload");
        VariantMap variants = new VariantMap();
        List variantIDs = message.getCriteria().getVariants();
        if (variantIDs != null) {
            for (String variantID : variantIDs) {
                Variant variant = this.genericVariantService.findByVariantID(variantID);
                if (variant == null) continue;
                variants.add(variant);
            }
        } else {
            variants.addAll(pushApplication.getVariants());
        }
        PushMessageInformation pushMessageInformation = this.metricsService.storeNewRequestFrom(pushApplication.getPushApplicationID(), message.toStrippedJsonString(), message.getIpAddress(), message.getClientIdentifier(), variants.getVariantCount());
        for (Map.Entry entry : variants.entrySet()) {
            this.dispatchVariantMessageEvent.fire((Object)new MessageHolderWithVariants(pushMessageInformation, message, (VariantType)entry.getKey(), (Collection)entry.getValue()));
        }
    }

    private static class VariantMap
    extends EnumMap<VariantType, List<Variant>> {
        private static final long serialVersionUID = -1942168038908630961L;

        VariantMap() {
            super(VariantType.class);
        }

        void add(Variant variant) {
            ArrayList<Variant> list = (ArrayList<Variant>)this.get(variant.getType());
            if (list == null) {
                list = new ArrayList<Variant>();
                this.put(variant.getType(), list);
            }
            list.add(variant);
        }

        void addAll(Collection<Variant> variants) {
            for (Variant variant : variants) {
                this.add(variant);
            }
        }

        int getVariantCount() {
            int count = 0;
            for (Collection variants : this.values()) {
                count += variants.size();
            }
            return count;
        }
    }
}

