/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.dao.ResultStreamException;
import org.jboss.aerogear.unifiedpush.dao.ResultsStream;
import org.jboss.aerogear.unifiedpush.message.Criteria;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.configuration.SenderConfiguration;
import org.jboss.aerogear.unifiedpush.message.event.AllBatchesLoadedEvent;
import org.jboss.aerogear.unifiedpush.message.event.BatchLoadedEvent;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithVariants;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.message.sender.SenderTypeLiteral;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@Stateless
public class TokenLoader {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(TokenLoader.class);
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    @DispatchToQueue
    private Event<MessageHolderWithTokens> dispatchTokensEvent;
    @Inject
    @DispatchToQueue
    private Event<MessageHolderWithVariants> nextBatchEvent;
    @Inject
    @DispatchToQueue
    private Event<BatchLoadedEvent> batchLoaded;
    @Inject
    @DispatchToQueue
    private Event<AllBatchesLoadedEvent> allBatchesLoaded;
    @Inject
    @DispatchToQueue
    private Event<VariantMetricInformation> dispatchVariantMetricEvent;
    @Inject
    @Any
    private Instance<SenderConfiguration> senderConfiguration;

    public void loadAndQueueTokenBatch(@Observes @Dequeue MessageHolderWithVariants msg) {
        UnifiedPushMessage message = msg.getUnifiedPushMessage();
        VariantType variantType = msg.getVariantType();
        Collection<Variant> variants = msg.getVariants();
        String lastTokenFromPreviousBatch = msg.getLastTokenFromPreviousBatch();
        SenderConfiguration configuration = (SenderConfiguration)this.senderConfiguration.select(new Annotation[]{new SenderTypeLiteral(variantType)}).get();
        this.logger.fine("Received message from queue: " + message.getMessage().getAlert());
        Criteria criteria = message.getCriteria();
        List categories = criteria.getCategories();
        List aliases = criteria.getAliases();
        List deviceTypes = criteria.getDeviceTypes();
        for (Variant variant : variants) {
            ResultsStream tokenStream = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(variant.getVariantID(), categories, aliases, deviceTypes, configuration.tokensToLoad(), lastTokenFromPreviousBatch).fetchSize(configuration.batchSize()).executeQuery();
            try {
                String lastTokenInBatch = null;
                int tokensLoaded = 0;
                for (int batchNumber = 0; batchNumber < configuration.batchesToLoad(); ++batchNumber) {
                    TreeSet<String> tokens = new TreeSet<String>();
                    for (int i = 0; i < configuration.batchSize() && tokenStream.next(); ++i) {
                        lastTokenInBatch = (String)tokenStream.get();
                        tokens.add(lastTokenInBatch);
                        ++tokensLoaded;
                    }
                    if (tokens.size() <= 0) break;
                    this.dispatchTokensEvent.fire((Object)new MessageHolderWithTokens(msg.getPushMessageInformation(), message, variant, tokens));
                    this.logger.fine(String.format("Loaded batch for %s variant (%s)", variant.getType().getTypeName(), variant.getVariantID()));
                    this.batchLoaded.fire((Object)new BatchLoadedEvent(variant.getVariantID()));
                }
                if (tokensLoaded >= configuration.tokensToLoad()) {
                    this.logger.fine(String.format("Ending token loading transaction for %s variant (%s)", variant.getType().getTypeName(), variant.getVariantID()));
                    this.nextBatchEvent.fire((Object)new MessageHolderWithVariants(msg.getPushMessageInformation(), message, msg.getVariantType(), variants, lastTokenInBatch));
                    continue;
                }
                this.logger.fine(String.format("All batches for %s variant were loaded (%s)", variant.getType().getTypeName(), msg.getPushMessageInformation().getId()));
                this.allBatchesLoaded.fire((Object)new AllBatchesLoadedEvent(variant.getVariantID()));
                if (tokensLoaded != 0 || lastTokenFromPreviousBatch != null) continue;
                VariantMetricInformation variantMetricInformation = new VariantMetricInformation();
                variantMetricInformation.setPushMessageInformation(msg.getPushMessageInformation());
                variantMetricInformation.setVariantID(variant.getVariantID());
                variantMetricInformation.setDeliveryStatus(Boolean.TRUE);
                this.dispatchVariantMetricEvent.fire((Object)variantMetricInformation);
            }
            catch (ResultStreamException e) {
                this.logger.severe("Failed to load batch of tokens", (Throwable)e);
            }
        }
    }
}

