/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

public abstract class AbstractServiceCache<T> {
    private static final long QUEUE_POLLING_INTERVAL_IN_MILLIS = 100L;
    private final ConcurrentHashMap<Key, Holder> holderMap = new ConcurrentHashMap();
    private final AeroGearLogger logger = AeroGearLogger.getInstance(this.getClass());
    private final int instanceLimit;
    private final long timeout;

    public AbstractServiceCache(int instanceLimit, long instanceAcquiringTimeoutInMillis) {
        this.instanceLimit = instanceLimit;
        this.timeout = instanceAcquiringTimeoutInMillis;
    }

    public T dequeueOrCreateNewService(String pushMessageInformationId, String variantID, ServiceConstructor<T> constructor) {
        Holder holder = this.getOrCreateHolder(new Key(pushMessageInformationId, variantID));
        Object service = holder.dequeueOrCreateBlocking(constructor, this.timeout);
        return service;
    }

    public T dequeue(String pushMessageInformationId, String variantID) {
        Holder holder = this.getHolder(new Key(pushMessageInformationId, variantID));
        if (holder == null) {
            return null;
        }
        return holder.dequeue();
    }

    public void queueFreedUpService(String pushMessageInformationId, String variantID, T service) {
        Holder holder = this.getOrCreateHolder(new Key(pushMessageInformationId, variantID));
        holder.queue(service);
        this.logger.fine("Freed up service returned to the queue");
    }

    public void freeUpSlot(String pushMessageInformationId, String variantID) {
        Key instanceKey = new Key(pushMessageInformationId, variantID);
        Holder holder = this.getOrCreateHolder(instanceKey);
        int newInstanceCount = holder.decrementCounter();
        if (newInstanceCount == 0) {
            this.freeUpHolder(instanceKey, holder);
        } else if (newInstanceCount < 0) {
            throw new IllegalStateException("Instance counter cant be less than zero");
        }
        this.logger.fine("Freed up a slot so that new services can be created within the limits");
    }

    private Holder getHolder(Key key) {
        return this.holderMap.get(key);
    }

    private Holder getOrCreateHolder(Key key) {
        Holder holder = this.holderMap.get(key);
        if (holder == null) {
            holder = this.holderMap.putIfAbsent(key, new Holder());
            holder = this.holderMap.get(key);
        }
        return holder;
    }

    private void freeUpHolder(Key key, Holder holder) {
        this.holderMap.remove(key, holder);
    }

    private static class Key {
        private String pushMessageInformationId;
        private String variantId;

        Key(String pushMessageInformationId, String variantID) {
            if (pushMessageInformationId == null) {
                throw new NullPointerException("pushMessageInformationId");
            }
            if (variantID == null) {
                throw new NullPointerException("variant or its variantID cant be null");
            }
            this.pushMessageInformationId = pushMessageInformationId;
            this.variantId = variantID;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pushMessageInformationId == null ? 0 : this.pushMessageInformationId.hashCode());
            result = 31 * result + (this.variantId == null ? 0 : this.variantId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.pushMessageInformationId == null ? other.pushMessageInformationId != null : !this.pushMessageInformationId.equals(other.pushMessageInformationId)) {
                return false;
            }
            return !(this.variantId == null ? other.variantId != null : !this.variantId.equals(other.variantId));
        }
    }

    private class Holder {
        private ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
        private AtomicInteger counter = new AtomicInteger(0);

        private Holder() {
        }

        public T dequeueOrCreateBlocking(ServiceConstructor<T> constructor, long timeoutInMillis) {
            long start = System.currentTimeMillis();
            while (start + timeoutInMillis > System.currentTimeMillis()) {
                Object service = this.dequeueOrCreate(constructor);
                if (service != null) {
                    return service;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            return null;
        }

        public void queue(T service) {
            this.queue.add(service);
        }

        public T dequeue() {
            return this.queue.poll();
        }

        public int decrementCounter() {
            return this.counter.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T dequeueOrCreate(ServiceConstructor<T> constructor) {
            if (!this.queue.isEmpty()) {
                AbstractServiceCache.this.logger.fine("Service available in a queue, taking it from there");
                return this.queue.poll();
            }
            int count = this.counter.get();
            if (count < AbstractServiceCache.this.instanceLimit) {
                if (this.counter.compareAndSet(count, count + 1)) {
                    AbstractServiceCache.this.logger.fine("No existing service available, creating new one");
                    Object service = null;
                    try {
                        service = constructor.construct();
                    }
                    finally {
                        if (service == null) {
                            AbstractServiceCache.this.logger.warning("Failed to create service, will try later");
                            this.counter.decrementAndGet();
                        }
                    }
                    return service;
                }
                AbstractServiceCache.this.logger.fine("No existing service available and ran out of limit, waiting for services to free up");
            }
            return null;
        }
    }

    public static interface ServiceConstructor<T> {
        public T construct();
    }
}

