/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.cache;

import com.notnoop.apns.ApnsService;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.message.cache.AbstractServiceCache;
import org.jboss.aerogear.unifiedpush.message.event.VariantCompletedEvent;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@ApplicationScoped
public class ApnsServiceCache
extends AbstractServiceCache<ApnsService> {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(ApnsServiceCache.class);
    public static final int INSTANCE_LIMIT = 10;
    public static final long INSTANCE_ACQUIRING_TIMEOUT = 5000L;
    @Inject
    private ClientInstallationService clientInstallationService;

    public ApnsServiceCache() {
        super(10, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUpAvailableServices(@Observes VariantCompletedEvent variantCompleted) {
        ApnsService service;
        String pushMessageInformationId = variantCompleted.getPushMessageInformationId();
        String variantID = variantCompleted.getVariantID();
        while ((service = (ApnsService)this.dequeue(pushMessageInformationId, variantID)) != null) {
            try {
                try {
                    Set<String> inactiveTokens = service.getInactiveDevices().keySet();
                    Set<String> transformedTokens = this.lowerCaseAllTokens(inactiveTokens);
                    if (!transformedTokens.isEmpty()) {
                        this.logger.info("Deleting '" + inactiveTokens.size() + "' invalid iOS installations");
                        this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(variantID, transformedTokens);
                    }
                }
                catch (Exception e) {
                    this.logger.severe("Unable to detect and delete inactive devices", (Throwable)e);
                }
                service.stop();
            }
            catch (Exception e) {
                this.logger.severe("Unable to stop ApnsService", (Throwable)e);
            }
            finally {
                this.freeUpSlot(pushMessageInformationId, variantID);
            }
        }
    }

    private Set<String> lowerCaseAllTokens(Set<String> inactiveTokens) {
        HashSet<String> lowerCaseTokens = new HashSet<String>();
        for (String token : inactiveTokens) {
            lowerCaseTokens.add(token.toLowerCase());
        }
        return lowerCaseTokens;
    }
}

