/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.configuration;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.configuration.SenderConfiguration;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.message.util.ConfigurationUtils;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

public class SenderConfigurationProvider {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(SenderConfigurationProvider.class);

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.ANDROID)
    public SenderConfiguration produceAndroidConfiguration() {
        return this.loadConfigurationFor(VariantType.ANDROID, new SenderConfiguration(10, 1000));
    }

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.ADM)
    public SenderConfiguration produceAdmConfiguration() {
        return this.loadConfigurationFor(VariantType.ADM, new SenderConfiguration(10, 1000));
    }

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.IOS)
    public SenderConfiguration produceIosConfiguration() {
        return this.loadConfigurationFor(VariantType.IOS, new SenderConfiguration(3, 10000));
    }

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.SIMPLE_PUSH)
    public SenderConfiguration produceSimplePushConfiguration() {
        return this.loadConfigurationFor(VariantType.SIMPLE_PUSH, new SenderConfiguration(10, 1000));
    }

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.WINDOWS_MPNS)
    public SenderConfiguration produceWindowsMpnsConfiguration() {
        return this.loadConfigurationFor(VariantType.WINDOWS_MPNS, new SenderConfiguration(10, 1000));
    }

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.WINDOWS_WNS)
    public SenderConfiguration produceWindowsWnsConfiguration() {
        return this.loadConfigurationFor(VariantType.WINDOWS_WNS, new SenderConfiguration(10, 1000));
    }

    private SenderConfiguration loadConfigurationFor(VariantType type, SenderConfiguration defaultConfiguration) {
        return this.validateAndSanitizeConfiguration(type, new SenderConfiguration(this.getProperty(type, ConfigurationProperty.batchesToLoad, defaultConfiguration.batchesToLoad(), Integer.class), this.getProperty(type, ConfigurationProperty.batchSize, defaultConfiguration.batchSize(), Integer.class)));
    }

    private SenderConfiguration validateAndSanitizeConfiguration(VariantType type, SenderConfiguration configuration) {
        switch (type) {
            case ANDROID: {
                if (configuration.batchSize() <= 1000) break;
                this.logger.warning(String.format("Sender configuration -D%s=%s is invalid: at most 1000 tokens can be submitted to GCM in one batch", this.getSystemPropertyName(type, ConfigurationProperty.batchSize), configuration.batchSize()));
                configuration.setBatchSize(1000);
                break;
            }
        }
        return configuration;
    }

    private <T> T getProperty(VariantType type, ConfigurationProperty property, T defaultValue, Class<T> expectedType) {
        String systemPropertyName = this.getSystemPropertyName(type, property);
        if (expectedType == String.class) {
            return (T)ConfigurationUtils.tryGetProperty(systemPropertyName, (String)defaultValue);
        }
        if (expectedType == Integer.class) {
            return (T)ConfigurationUtils.tryGetIntegerProperty(systemPropertyName, (Integer)defaultValue);
        }
        throw new IllegalStateException("Unexpected type: " + expectedType);
    }

    private String getSystemPropertyName(VariantType type, ConfigurationProperty property) {
        return String.format("aerogear.%s.%s", type.getTypeName(), property.toString());
    }

    private static enum ConfigurationProperty {
        batchesToLoad,
        batchSize;

    }
}

