/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.jms.Destination;
import javax.jms.Queue;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.jms.AbstractJMSMessageProducer;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;

@Stateless
public class MessageHolderWithTokensProducer
extends AbstractJMSMessageProducer {
    @Resource(mappedName="java:/queue/AdmTokenBatchQueue")
    private Queue admTokenBatchQueue;
    @Resource(mappedName="java:/queue/APNsTokenBatchQueue")
    private Queue apnsTokenBatchQueue;
    @Resource(mappedName="java:/queue/GCMTokenBatchQueue")
    private Queue gcmTokenBatchQueue;
    @Resource(mappedName="java:/queue/MPNSTokenBatchQueue")
    private Queue mpnsTokenBatchQueue;
    @Resource(mappedName="java:/queue/SimplePushTokenBatchQueue")
    private Queue simplePushTokenBatchQueue;
    @Resource(mappedName="java:/queue/WNSTokenBatchQueue")
    private Queue wnsTokenBatchQueue;

    public void queueMessageVariantForProcessing(@Observes @DispatchToQueue MessageHolderWithTokens msg) {
        this.sendTransacted((Destination)this.selectQueue(msg.getVariant().getType()), msg);
    }

    private Queue selectQueue(VariantType variantType) {
        switch (variantType) {
            case ADM: {
                return this.admTokenBatchQueue;
            }
            case ANDROID: {
                return this.gcmTokenBatchQueue;
            }
            case IOS: {
                return this.apnsTokenBatchQueue;
            }
            case SIMPLE_PUSH: {
                return this.simplePushTokenBatchQueue;
            }
            case WINDOWS_MPNS: {
                return this.mpnsTokenBatchQueue;
            }
            case WINDOWS_WNS: {
                return this.wnsTokenBatchQueue;
            }
        }
        throw new IllegalStateException("Unknown variant type queue");
    }
}

