/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsDelegateAdapter;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ApnsServiceBuilder;
import com.notnoop.apns.DeliveryError;
import com.notnoop.apns.PayloadBuilder;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.ApnsDeliveryErrorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.jboss.aerogear.unifiedpush.message.Message;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.apns.APNs;
import org.jboss.aerogear.unifiedpush.message.cache.AbstractServiceCache;
import org.jboss.aerogear.unifiedpush.message.cache.ApnsServiceCache;
import org.jboss.aerogear.unifiedpush.message.exception.PushNetworkUnreachableException;
import org.jboss.aerogear.unifiedpush.message.exception.SenderResourceNotAvailableException;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.message.util.ConfigurationUtils;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@SenderType(value=VariantType.IOS)
public class APNsPushNotificationSender
implements PushNotificationSender {
    public static final String CUSTOM_AEROGEAR_APNS_PUSH_HOST = "custom.aerogear.apns.push.host";
    public static final String CUSTOM_AEROGEAR_APNS_PUSH_PORT = "custom.aerogear.apns.push.port";
    private static final String CUSTOM_AEROGEAR_APNS_FEEDBACK_HOST = "custom.aerogear.apns.feedback.host";
    private static final String CUSTOM_AEROGEAR_APNS_FEEDBACK_PORT = "custom.aerogear.apns.feedback.port";
    private static final String customAerogearApnsPushHost = ConfigurationUtils.tryGetProperty("custom.aerogear.apns.push.host");
    private static final Integer customAerogearApnsPushPort = ConfigurationUtils.tryGetIntegerProperty("custom.aerogear.apns.push.port");
    private static final String customAerogearApnsFeedbackHost = ConfigurationUtils.tryGetProperty("custom.aerogear.apns.feedback.host");
    private static final Integer customAerogearApnsFeedbackPort = ConfigurationUtils.tryGetIntegerProperty("custom.aerogear.apns.feedback.port");
    private final AeroGearLogger logger = AeroGearLogger.getInstance(APNsPushNotificationSender.class);
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private ApnsServiceCache apnsServiceCache;

    public APNsPushNotificationSender() {
    }

    APNsPushNotificationSender(ApnsServiceCache apnsServiceCache) {
        this.apnsServiceCache = apnsServiceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, String pushMessageInformationId, final NotificationSenderCallback callback) {
        if (tokens.isEmpty()) {
            return;
        }
        final iOSVariant iOSVariant2 = (iOSVariant)variant;
        Message message = pushMessage.getMessage();
        APNs apns = message.getApns();
        PayloadBuilder builder = APNS.newPayload().alertBody(message.getAlert()).badge(message.getBadge()).sound(message.getSound()).alertTitle(apns.getTitle()).alertAction(apns.getAction()).urlArgs(apns.getUrlArgs()).category(apns.getActionCategory()).localizedTitleKey(apns.getLocalizedTitleKey());
        if (apns.getLocalizedTitleArguments() != null) {
            builder.localizedArguments(apns.getLocalizedTitleArguments());
        }
        if (apns.isContentAvailable()) {
            builder = builder.instantDeliveryOrSilentNotification();
        }
        builder = builder.customFields(message.getUserData());
        if ((builder = builder.customField("aerogear-push-id", (Object)pushMessageInformationId)).isTooLong()) {
            callback.onError("Nothing sent to APNs since the payload is too large");
            return;
        }
        String apnsMessage = builder.build();
        ApnsService service = this.apnsServiceCache.dequeueOrCreateNewService(pushMessageInformationId, iOSVariant2.getVariantID(), new AbstractServiceCache.ServiceConstructor<ApnsService>(){

            @Override
            public ApnsService construct() {
                ApnsService service = APNsPushNotificationSender.this.buildApnsService(iOSVariant2, callback);
                if (service == null) {
                    callback.onError("No certificate was found. Could not send messages to APNs");
                    throw new IllegalStateException("No certificate was found. Could not send messages to APNs");
                }
                APNsPushNotificationSender.this.logger.fine("Starting APNs service");
                try {
                    service.start();
                }
                catch (Exception e) {
                    throw new PushNetworkUnreachableException(e);
                }
                return service;
            }
        });
        if (service == null) {
            throw new SenderResourceNotAvailableException("Unable to obtain a ApnsService instance");
        }
        try {
            this.logger.fine("Sending transformed APNs payload: " + apnsMessage);
            Date expireDate = this.createFutureDateBasedOnTTL(pushMessage.getConfig().getTimeToLive());
            service.push(tokens, apnsMessage, expireDate);
            this.logger.info("One batch to APNs has been submitted");
            this.apnsServiceCache.queueFreedUpService(pushMessageInformationId, iOSVariant2.getVariantID(), service);
            try {
                service = null;
                callback.onSuccess();
            }
            catch (Exception e) {
                this.logger.severe("Failed to call onSuccess after successful push", (Throwable)e);
            }
        }
        catch (Exception e) {
            try {
                this.logger.warning("APNs service died in the middle of sending, stopping it");
                try {
                    service.stop();
                }
                catch (Exception ex) {
                    this.logger.severe("Failed to stop the APNs service after failure", (Throwable)ex);
                }
                callback.onError("Error sending payload to APNs server: " + e.getMessage());
            }
            finally {
                this.apnsServiceCache.freeUpSlot(pushMessageInformationId, iOSVariant2.getVariantID());
            }
        }
    }

    private Date createFutureDateBasedOnTTL(int ttl) {
        if (ttl == -1) {
            return new Date(System.currentTimeMillis() + 2147483647000L);
        }
        return new Date(System.currentTimeMillis() + (long)ttl);
    }

    private ApnsService buildApnsService(final iOSVariant iOSVariant2, NotificationSenderCallback notificationSenderCallback) {
        if (iOSVariant2.getCertificate() != null && iOSVariant2.getPassphrase() != null) {
            ApnsServiceBuilder builder = APNS.newService();
            builder.withDelegate((ApnsDelegate)new ApnsDelegateAdapter(){

                public void messageSent(ApnsNotification message, boolean resent) {
                    APNsPushNotificationSender.this.logger.finest("Sending APNs message to: " + message.getDeviceToken());
                }

                public void messageSendFailed(ApnsNotification message, Throwable e) {
                    if (e.getClass().isAssignableFrom(ApnsDeliveryErrorException.class)) {
                        ApnsDeliveryErrorException deliveryError = (ApnsDeliveryErrorException)e;
                        if (DeliveryError.INVALID_TOKEN.equals((Object)deliveryError.getDeliveryError())) {
                            String invalidToken = Utilities.encodeHex((byte[])message.getDeviceToken()).toLowerCase();
                            APNsPushNotificationSender.this.logger.info("Removing invalid token: " + invalidToken);
                            APNsPushNotificationSender.this.clientInstallationService.removeInstallationForVariantByDeviceToken(iOSVariant2.getVariantID(), invalidToken);
                        } else {
                            APNsPushNotificationSender.this.logger.severe("Error sending payload to APNs server", e);
                        }
                    }
                }
            });
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(iOSVariant2.getCertificate());
                builder.withCert((InputStream)stream, iOSVariant2.getPassphrase());
                stream.close();
            }
            catch (Exception e) {
                this.logger.severe("Error reading certificate", (Throwable)e);
                return null;
            }
            this.configureDestinations(iOSVariant2, builder);
            return builder.build();
        }
        return null;
    }

    private void configureDestinations(iOSVariant iOSVariant2, ApnsServiceBuilder builder) {
        int port;
        builder.withAppleDestination(iOSVariant2.isProduction());
        if (customAerogearApnsPushHost != null) {
            port = 2195;
            if (customAerogearApnsPushPort != null) {
                port = customAerogearApnsPushPort;
            }
            builder.withGatewayDestination(customAerogearApnsPushHost, port);
        }
        if (customAerogearApnsFeedbackHost != null) {
            port = 2196;
            if (customAerogearApnsFeedbackPort != null) {
                port = customAerogearApnsFeedbackPort;
            }
            builder.withFeedbackDestination(customAerogearApnsFeedbackHost, port);
        }
    }
}

