/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.Message;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.message.sender.WNSPushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.windows.Windows;
import org.jboss.aerogear.windows.mpns.MPNS;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.MpnsService;
import org.jboss.aerogear.windows.mpns.notifications.TileNotification;
import org.jboss.aerogear.windows.mpns.notifications.ToastNotification;

@SenderType(value=VariantType.WINDOWS_MPNS)
public class MPNSPushNotificationSender
implements PushNotificationSender {
    @Override
    public void sendPushMessage(Variant variant, Collection<String> clientIdentifiers, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback senderCallback) {
        TileNotification notification;
        if (clientIdentifiers.isEmpty()) {
            return;
        }
        MpnsService mpnsService = MPNS.newService().build();
        Message message = pushMessage.getMessage();
        if (message.getWindows().getType() != null) {
            switch (message.getWindows().getType()) {
                case toast: {
                    ToastNotification.Builder builder = MPNS.newNotification().toast().parameter(WNSPushNotificationSender.createLaunchParam(message.getWindows().getPage(), message.getAlert(), message.getUserData(), pushMessageInformationId)).title(message.getAlert());
                    if (!message.getWindows().getTextFields().isEmpty()) {
                        builder.subtitle((String)message.getWindows().getTextFields().get(0));
                    }
                    notification = builder.build();
                    break;
                }
                case badge: {
                    notification = MPNS.newNotification().tile().count(message.getBadge()).build();
                    break;
                }
                case raw: {
                    notification = MPNS.newNotification().raw().body(message.getAlert()).build();
                    break;
                }
                case tile: {
                    List textFields;
                    Windows windows = message.getWindows();
                    TileNotification.Builder tile = MPNS.newNotification().tile();
                    tile.title(message.getAlert());
                    List images = windows.getImages();
                    if (images.size() >= 1) {
                        tile.backgroundImage((String)images.get(0));
                    }
                    if (images.size() >= 2) {
                        tile.backBackgroundImage((String)images.get(1));
                    }
                    if ((textFields = windows.getTextFields()).size() >= 1) {
                        tile.backTitle((String)textFields.get(0));
                    }
                    if (textFields.size() >= 2) {
                        tile.backContent((String)textFields.get(1));
                    }
                    notification = tile.build();
                    break;
                }
                default: {
                    senderCallback.onError("unknown type: " + message.getWindows().getType());
                    throw new IllegalArgumentException("unknown type: " + message.getWindows().getType());
                }
            }
        } else {
            notification = MPNS.newNotification().toast().parameter(WNSPushNotificationSender.createLaunchParam(message.getWindows().getPage(), message.getAlert(), message.getUserData(), pushMessageInformationId)).title(message.getAlert()).build();
        }
        for (String identifier : clientIdentifiers) {
            mpnsService.push(identifier, (MpnsNotification)notification);
        }
        senderCallback.onSuccess();
    }
}

