/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@SenderType(value=VariantType.SIMPLE_PUSH)
public class SimplePushNotificationSender
implements PushNotificationSender {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final AeroGearLogger logger = AeroGearLogger.getInstance(SimplePushNotificationSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback callback) {
        if (tokens.isEmpty()) {
            return;
        }
        String payload = pushMessage.getMessage().getSimplePush();
        if (payload == null) {
            payload = "";
        }
        boolean hasWarning = false;
        for (String clientURL : tokens) {
            HttpURLConnection conn = null;
            try {
                this.logger.finest("Sending out SimplePush payload: " + payload);
                conn = this.put(clientURL, payload);
                int simplePushStatusCode = conn.getResponseCode();
                this.logger.finest("SimplePush Status: " + simplePushStatusCode);
                if (Response.Status.OK.getStatusCode() == simplePushStatusCode) continue;
                hasWarning = true;
            }
            catch (Exception e) {
                this.logger.severe("Error delivering SimplePush payload", (Throwable)e);
                hasWarning = true;
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
        if (hasWarning) {
            callback.onError("Error delivering SimplePush payload");
        } else {
            callback.onSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection put(String url, String body) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("SimplePush Update URL cannot be null");
        }
        byte[] bytes = body.getBytes(UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestMethod("PUT");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }
}

