/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import ar.com.fernandospr.wns.WnsService;
import ar.com.fernandospr.wns.exceptions.WnsException;
import ar.com.fernandospr.wns.model.WnsBadge;
import ar.com.fernandospr.wns.model.WnsNotificationResponse;
import ar.com.fernandospr.wns.model.WnsRaw;
import ar.com.fernandospr.wns.model.WnsTile;
import ar.com.fernandospr.wns.model.WnsToast;
import ar.com.fernandospr.wns.model.builders.WnsAbstractBuilder;
import ar.com.fernandospr.wns.model.builders.WnsBadgeBuilder;
import ar.com.fernandospr.wns.model.builders.WnsRawBuilder;
import ar.com.fernandospr.wns.model.builders.WnsTileBuilder;
import ar.com.fernandospr.wns.model.builders.WnsToastBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.api.WindowsWNSVariant;
import org.jboss.aerogear.unifiedpush.message.Message;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.message.windows.Windows;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@SenderType(value=VariantType.WINDOWS_WNS)
public class WNSPushNotificationSender
implements PushNotificationSender {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(WNSPushNotificationSender.class);
    private static final String CORDOVA = "cordova";
    static final String CORDOVA_PAGE = "/Plugins/org.jboss.aerogear.cordova.push/P.xaml";
    private String pushMessageInformationId;
    @Inject
    private ClientInstallationService clientInstallationService;

    @Override
    public void sendPushMessage(Variant variant, Collection<String> clientIdentifiers, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback senderCallback) {
        this.setPushMessageInformationId(pushMessageInformationId);
        if (clientIdentifiers.isEmpty()) {
            return;
        }
        WindowsWNSVariant windowsVariant = (WindowsWNSVariant)variant;
        WnsService wnsService = new WnsService(windowsVariant.getSid(), windowsVariant.getClientSecret(), false);
        HashSet<String> expiredClientIdentifiers = new HashSet<String>(clientIdentifiers.size());
        ArrayList<String> channelUris = new ArrayList<String>(clientIdentifiers);
        Message message = pushMessage.getMessage();
        try {
            List responses;
            block13: {
                block12: {
                    if (message.getWindows().getType() == null) break block12;
                    switch (message.getWindows().getType()) {
                        case toast: {
                            responses = wnsService.pushToast(channelUris, this.createToastMessage(message));
                            break block13;
                        }
                        case badge: {
                            responses = wnsService.pushBadge(channelUris, this.createBadgeMessage(message));
                            break block13;
                        }
                        case raw: {
                            responses = wnsService.pushRaw(channelUris, this.createRawMessage(message));
                            break block13;
                        }
                        case tile: {
                            responses = wnsService.pushTile(channelUris, this.createTileMessage(message));
                            break block13;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown type: " + message.getWindows().getType());
                        }
                    }
                }
                responses = wnsService.pushToast(channelUris, this.createSimpleToastMessage(message));
            }
            for (WnsNotificationResponse response : responses) {
                if (response.code != 410) continue;
                expiredClientIdentifiers.add(response.channelUri);
            }
            if (!expiredClientIdentifiers.isEmpty()) {
                this.logger.info(String.format("Deleting '%d' expired WNS installations", expiredClientIdentifiers.size()));
                this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(variant.getVariantID(), expiredClientIdentifiers);
            }
            this.logger.fine("Message to WNS has been submitted");
            senderCallback.onSuccess();
        }
        catch (WnsException exception) {
            senderCallback.onError(exception.getMessage());
        }
        catch (IllegalArgumentException iae) {
            senderCallback.onError(iae.getMessage());
        }
    }

    WnsToast createToastMessage(Message message) {
        WnsToastBuilder builder = new WnsToastBuilder();
        Windows windows = message.getWindows();
        if (windows.getDuration() != null) {
            builder.duration(windows.getDuration().toString());
        }
        builder.audioSrc(message.getSound());
        builder.launch(WNSPushNotificationSender.createLaunchParam(message.getWindows().getPage(), message.getAlert(), message.getUserData(), this.getPushMessageInformationId()));
        this.createMessage(message, windows.getToastType().toString(), (WnsAbstractBuilder)builder);
        return builder.build();
    }

    private WnsBadge createBadgeMessage(Message message) {
        WnsBadgeBuilder builder = new WnsBadgeBuilder();
        Windows windows = message.getWindows();
        if (windows.getBadge() != null) {
            builder.value(windows.getBadge().toString());
        } else {
            builder.value(Integer.valueOf(message.getBadge()));
        }
        return builder.build();
    }

    private WnsRaw createRawMessage(Message message) {
        WnsRawBuilder builder = new WnsRawBuilder();
        builder.stream(message.getAlert().getBytes());
        return builder.build();
    }

    WnsTile createTileMessage(Message message) {
        WnsTileBuilder builder = new WnsTileBuilder();
        this.createMessage(message, message.getWindows().getTileType().toString(), (WnsAbstractBuilder)builder);
        return builder.build();
    }

    private void createMessage(Message message, String type, WnsAbstractBuilder builder) {
        Windows windows = message.getWindows();
        ArrayList<String> param = new ArrayList<String>(windows.getImages());
        param.add(message.getAlert());
        param.addAll(windows.getTextFields());
        this.createTemplate(builder, type, param);
    }

    private void createTemplate(WnsAbstractBuilder builder, String type, List<String> param) {
        try {
            Method[] methods;
            for (Method method : methods = builder.getClass().getMethods()) {
                if (!method.getName().equals("bindingTemplate" + type)) continue;
                int methodArgs = method.getParameterTypes().length;
                if (methodArgs == param.size()) {
                    method.invoke((Object)builder, (Object[])param.toArray(new String[param.size()]));
                    continue;
                }
                throw new IllegalArgumentException("this template needs " + methodArgs + " fields, but you specified " + param.size());
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("error thrown while invoking template build method: " + type, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("something wrong with the permissions of this method", e);
        }
    }

    WnsToast createSimpleToastMessage(Message message) {
        WnsToastBuilder builder = new WnsToastBuilder().bindingTemplateToastText01(message.getAlert());
        Map data = message.getUserData();
        builder.launch(WNSPushNotificationSender.createLaunchParam(message.getWindows().getPage(), message.getAlert(), data, this.getPushMessageInformationId()));
        return builder.build();
    }

    public String getPushMessageInformationId() {
        return this.pushMessageInformationId;
    }

    public void setPushMessageInformationId(String pushMessageInformationId) {
        this.pushMessageInformationId = pushMessageInformationId;
    }

    static String createLaunchParam(String page, String message, Map<String, Object> data, String pushMessageInformationId) {
        if (page != null) {
            UriBuilder uriBuilder = UriBuilder.fromPath((String)"");
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                uriBuilder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            if (message != null) {
                uriBuilder.queryParam("message", new Object[]{message});
            }
            uriBuilder.queryParam("aerogear-push-id", new Object[]{pushMessageInformationId});
            String query = uriBuilder.build(new Object[0]).getQuery();
            return (CORDOVA.equals(page) ? CORDOVA_PAGE : page) + (query != null ? "?" + query : "");
        }
        return null;
    }
}

