/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.util;

import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

public final class ConfigurationUtils {
    private static final AeroGearLogger logger = AeroGearLogger.getInstance(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    public static String tryGetProperty(String key) {
        return ConfigurationUtils.tryGetProperty(key, null);
    }

    public static String tryGetProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            logger.severe("Could not get value of property " + key + " due to SecurityManager. Using null value.");
            return null;
        }
    }

    public static Integer tryGetIntegerProperty(String key) {
        return ConfigurationUtils.tryGetIntegerProperty(key, null);
    }

    public static Integer tryGetIntegerProperty(String key, Integer defaultValue) {
        try {
            return Integer.getInteger(key, defaultValue);
        }
        catch (SecurityException e) {
            logger.severe("Could not get value of property " + key + " due to SecurityManager. Using null value.");
            return defaultValue;
        }
    }
}

