/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import org.jboss.aerogear.unifiedpush.message.HealthNetworkService;
import org.jboss.aerogear.unifiedpush.message.util.ConfigurationUtils;
import org.jboss.aerogear.unifiedpush.service.impl.health.HealthDetails;
import org.jboss.aerogear.unifiedpush.service.impl.health.Ping;
import org.jboss.aerogear.unifiedpush.service.impl.health.PushNetwork;
import org.jboss.aerogear.unifiedpush.service.impl.health.Status;

@Stateless
public class HealthNetworkServiceImpl
implements HealthNetworkService {
    private static final String customAerogearApnsPushHost = ConfigurationUtils.tryGetProperty("custom.aerogear.apns.push.host");
    private static final Integer customAerogearApnsPushPort = ConfigurationUtils.tryGetIntegerProperty("custom.aerogear.apns.push.port");
    private static final String GCM_SEND_ENDPOINT = "https://android.googleapis.com/gcm/send".substring("https://".length(), "https://android.googleapis.com/gcm/send".indexOf(47, "https://".length()));
    public static final String WNS_SEND_ENDPOINT = "db3.notify.windows.com";
    private static final List<PushNetwork> PUSH_NETWORKS = new ArrayList<PushNetwork>(Arrays.asList(new PushNetwork("Google Cloud Messaging", GCM_SEND_ENDPOINT, 443), new PushNetwork("Apple Push Network Sandbox", "gateway.sandbox.push.apple.com", 2195), new PushNetwork("Apple Push Network Production", "gateway.push.apple.com", 2195), new PushNetwork("Windows Push Network", "db3.notify.windows.com", 443)));

    @Override
    @Asynchronous
    public Future<List<HealthDetails>> networkStatus() {
        ArrayList<HealthDetails> results = new ArrayList<HealthDetails>(PUSH_NETWORKS.size());
        for (PushNetwork pushNetwork : PUSH_NETWORKS) {
            HealthDetails details = new HealthDetails();
            details.start();
            details.setDescription(pushNetwork.getName());
            if (Ping.isReachable((String)pushNetwork.getHost(), (int)pushNetwork.getPort())) {
                details.setTestStatus(Status.OK);
                details.setResult("online");
            } else {
                details.setResult(String.format("Network not reachable '%s'", pushNetwork.getName()));
                details.setTestStatus(Status.WARN);
            }
            results.add(details);
            details.stop();
        }
        return new AsyncResult(results);
    }

    static {
        if (customAerogearApnsPushHost != null) {
            int port = customAerogearApnsPushPort != null ? customAerogearApnsPushPort : 2195;
            PUSH_NETWORKS.add(new PushNetwork("Proxy host", customAerogearApnsPushHost, port));
        }
    }
}

