/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.jboss.aerogear.unifiedpush.message.exception.MessageDeliveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSMessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJMSMessageProducer.class);
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory xaConnectionFactory;

    protected void sendNonTransacted(Destination destination, Serializable message) {
        this.send(destination, message, null, null, false);
    }

    protected void sendTransacted(Destination destination, Serializable message) {
        this.send(destination, message, null, null, true);
    }

    protected void sendNonTransacted(Destination destination, Serializable message, String propertyName, String propertValue) {
        this.send(destination, message, propertyName, propertValue, false);
    }

    protected void sendTransacted(Destination destination, Serializable message, String propertyName, String propertValue) {
        this.send(destination, message, propertyName, propertValue, true);
    }

    private void send(Destination destination, Serializable message, String propertyName, String propertValue, boolean transacted) {
        Connection connection = null;
        try {
            connection = transacted ? this.xaConnectionFactory.createConnection() : this.connectionFactory.createConnection();
            Session session = connection.createSession(transacted, 1);
            MessageProducer messageProducer = session.createProducer(destination);
            connection.start();
            ObjectMessage objectMessage = session.createObjectMessage(message);
            if (propertyName != null) {
                objectMessage.setStringProperty(propertyName, propertValue);
            }
            messageProducer.send((Message)objectMessage);
        }
        catch (JMSException e) {
            throw new MessageDeliveryException("Failed to queue push message for further processing", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    logger.error("Failed to close JMS connection: ", (Throwable)e);
                }
            }
        }
    }
}

