/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import javax.annotation.Resource;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.jboss.aerogear.unifiedpush.message.event.AllBatchesLoadedEvent;
import org.jboss.aerogear.unifiedpush.message.event.BatchLoadedEvent;
import org.jboss.aerogear.unifiedpush.message.event.MetricsProcessingStartedEvent;
import org.jboss.aerogear.unifiedpush.message.event.TriggerMetricCollectionEvent;
import org.jboss.aerogear.unifiedpush.message.event.TriggerVariantMetricCollectionEvent;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.message.util.JmsClient;

public class CdiJmsBridge {
    @Resource(mappedName="java:/queue/AllBatchesLoadedQueue")
    private Queue allBatchesLoadedQueue;
    @Resource(mappedName="java:/queue/BatchLoadedQueue")
    private Queue batchLoadedQueue;
    @Resource(mappedName="java:/queue/TriggerMetricCollectionQueue")
    private Queue triggerMetricCollectionQueue;
    @Resource(mappedName="java:/queue/TriggerVariantMetricCollectionQueue")
    private Queue triggerVariantMetricCollectionQueue;
    @Resource(mappedName="java:/topic/MetricsProcessingStartedTopic")
    private Topic metricsProcessingStartedTopic;
    @Inject
    private JmsClient jmsClient;

    public void queueMessage(@Observes @DispatchToQueue AllBatchesLoadedEvent event) {
        this.jmsClient.send(event).inTransaction().withProperty("variantID", event.getVariantID()).to((Destination)this.allBatchesLoadedQueue);
    }

    public void queueMessage(@Observes @DispatchToQueue BatchLoadedEvent event) {
        this.jmsClient.send(event).inTransaction().withProperty("variantID", event.getVariantID()).to((Destination)this.batchLoadedQueue);
    }

    public void queueMessage(@Observes @DispatchToQueue TriggerMetricCollectionEvent event) {
        this.jmsClient.send(event).withDuplicateDetectionId(event.getPushMessageInformationId()).withDelayedDelivery(500L).to((Destination)this.triggerMetricCollectionQueue);
    }

    public void queueMessage(@Observes @DispatchToQueue TriggerVariantMetricCollectionEvent event) {
        this.jmsClient.send(event).to((Destination)this.triggerVariantMetricCollectionQueue);
    }

    public void broadcastMessage(@Observes @DispatchToQueue MetricsProcessingStartedEvent event) {
        this.jmsClient.send(event).to((Destination)this.metricsProcessingStartedTopic);
    }
}

