/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithVariants;
import org.jboss.aerogear.unifiedpush.message.jms.AbstractJMSMessageProducer;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;

@Stateless
public class MessageHolderWithVariantsProducer
extends AbstractJMSMessageProducer {
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Resource(mappedName="java:/queue/AdmPushMessageQueue")
    private Queue admPushMessageQueue;
    @Resource(mappedName="java:/queue/APNsPushMessageQueue")
    private Queue apnsPushMessageQueue;
    @Resource(mappedName="java:/queue/GCMPushMessageQueue")
    private Queue gcmPushMessageQueue;
    @Resource(mappedName="java:/queue/MPNSPushMessageQueue")
    private Queue mpnsPushMessageQueue;
    @Resource(mappedName="java:/queue/SimplePushMessageQueue")
    private Queue simplePushMessageQueue;
    @Resource(mappedName="java:/queue/WNSPushMessageQueue")
    private Queue wnsPushMessageQueue;

    public void queueMessageVariantForProcessing(@Observes @DispatchToQueue MessageHolderWithVariants msg) {
        this.sendTransacted((Destination)this.selectQueue(msg.getVariantType()), msg);
    }

    private Queue selectQueue(VariantType variantType) {
        switch (variantType) {
            case ADM: {
                return this.admPushMessageQueue;
            }
            case ANDROID: {
                return this.gcmPushMessageQueue;
            }
            case IOS: {
                return this.apnsPushMessageQueue;
            }
            case SIMPLE_PUSH: {
                return this.simplePushMessageQueue;
            }
            case WINDOWS_MPNS: {
                return this.mpnsPushMessageQueue;
            }
            case WINDOWS_WNS: {
                return this.wnsPushMessageQueue;
            }
        }
        throw new IllegalStateException("Unknown variant type queue");
    }
}

