/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import java.util.Collection;
import org.jboss.aerogear.adm.ADM;
import org.jboss.aerogear.adm.AdmService;
import org.jboss.aerogear.adm.PayloadBuilder;
import org.jboss.aerogear.unifiedpush.api.AdmVariant;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SenderType(value=VariantType.ADM)
public class AdmPushNotificationSender
implements PushNotificationSender {
    private final Logger logger = LoggerFactory.getLogger(AdmPushNotificationSender.class);

    @Override
    public void sendPushMessage(Variant variant, Collection<String> clientIdentifiers, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback senderCallback) {
        AdmService admService = ADM.newService();
        PayloadBuilder builder = ADM.newPayload();
        builder.dataField("alert", (Object)pushMessage.getMessage().getAlert());
        int ttl = pushMessage.getConfig().getTimeToLive();
        if (ttl != -1) {
            builder.expiresAfter((Object)ttl);
        }
        builder.dataField("message", (Object)"useless payload");
        builder.consolidationKey((Object)pushMessage.getMessage().getConsolidationKey());
        pushMessage.getMessage().getUserData().keySet().forEach(key -> builder.dataField(key, pushMessage.getMessage().getUserData().get(key)));
        builder.dataField("aerogear-push-id", (Object)pushMessageInformationId);
        AdmVariant admVariant = (AdmVariant)variant;
        clientIdentifiers.forEach(token -> {
            try {
                admService.sendMessageToDevice(token, admVariant.getClientId(), admVariant.getClientSecret(), builder.build());
                senderCallback.onSuccess();
            }
            catch (Exception e) {
                this.logger.error("Error sending payload to ADM server", (Throwable)e);
                senderCallback.onError(e.getMessage());
            }
        });
        this.logger.info(String.format("Sent push notification to Amazon's ADM Server for %d tokens", clientIdentifiers.size()));
    }
}

