/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SenderType(value=VariantType.SIMPLE_PUSH)
public class SimplePushNotificationSender
implements PushNotificationSender {
    private final Logger logger = LoggerFactory.getLogger(SimplePushNotificationSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback callback) {
        if (tokens.isEmpty()) {
            return;
        }
        String payload = pushMessage.getMessage().getSimplePush();
        if (payload == null) {
            payload = "";
        }
        boolean hasWarning = false;
        for (String clientURL : tokens) {
            HttpURLConnection conn = null;
            try {
                this.logger.trace("Sending out SimplePush payload: {}", (Object)payload);
                conn = this.put(clientURL, payload);
                int simplePushStatusCode = conn.getResponseCode();
                this.logger.trace("SimplePush Status: {}", (Object)simplePushStatusCode);
                if (Response.Status.OK.getStatusCode() == simplePushStatusCode) continue;
                hasWarning = true;
            }
            catch (Exception e) {
                this.logger.error("Error delivering SimplePush payload", (Throwable)e);
                hasWarning = true;
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
        this.logger.info(String.format("Sent push notification to SimplePush Server for %d  tokens", tokens.size()));
        if (hasWarning) {
            callback.onError("Error delivering SimplePush payload");
        } else {
            callback.onSuccess();
        }
    }

    protected HttpURLConnection put(String url, String body) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("SimplePush Update URL cannot be null");
        }
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestMethod("PUT");
        try (OutputStream out = conn.getOutputStream();){
            out.write(bytes);
            out.flush();
        }
        return conn;
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(url).openConnection();
    }
}

