/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.serviceHolder;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.Queue;
import org.jboss.aerogear.unifiedpush.message.serviceHolder.DisposableReference;
import org.jboss.aerogear.unifiedpush.message.serviceHolder.ServiceConstructor;
import org.jboss.aerogear.unifiedpush.message.serviceHolder.ServiceDestroyer;
import org.jboss.aerogear.unifiedpush.message.serviceHolder.ServiceDisposalScheduler;
import org.jboss.aerogear.unifiedpush.message.util.JmsClient;

public abstract class AbstractServiceHolder<T> {
    private final Map<Key, ConcurrentLinkedQueue<DisposableReference<T>>> queueMap = new ConcurrentHashMap<Key, ConcurrentLinkedQueue<DisposableReference<T>>>();
    private final int instanceLimit;
    private final long instanceAcquiringTimeoutInMillis;
    private final long serviceDisposalDelayInMillis;
    @Inject
    private JmsClient jmsClient;
    @Inject
    private ServiceDisposalScheduler serviceDisposalScheduler;

    public abstract Queue getFreeServiceSlotQueue();

    public AbstractServiceHolder(int instanceLimit, long instanceAcquiringTimeoutInMillis, long serviceDisposalDelayInMillis) {
        this.instanceLimit = instanceLimit;
        this.instanceAcquiringTimeoutInMillis = instanceAcquiringTimeoutInMillis;
        this.serviceDisposalDelayInMillis = serviceDisposalDelayInMillis;
    }

    public void initialize(String pushMessageInformationId, String variantID) {
        for (int i = 0; i < this.instanceLimit; ++i) {
            this.returnServiceSlotToQueue(pushMessageInformationId, variantID);
        }
    }

    public void destroy(String pushMessageInformationId, String variantID) {
        for (int i = 0; i < this.instanceLimit; ++i) {
            if (this.borrowServiceSlotFromQueue(pushMessageInformationId, variantID) != null) continue;
            return;
        }
    }

    public T dequeueOrCreateNewService(String pushMessageInformationId, String variantID, ServiceConstructor<T> constructor) {
        T instance = this.dequeue(pushMessageInformationId, variantID);
        if (instance != null) {
            return instance;
        }
        if (this.borrowServiceSlotFromQueue(pushMessageInformationId, variantID) != null) {
            return constructor.construct();
        }
        return null;
    }

    public T dequeue(String pushMessageInformationId, String variantID) {
        DisposableReference<T> serviceHolder;
        ConcurrentLinkedQueue<DisposableReference<T>> concurrentLinkedQueue = this.getCache(pushMessageInformationId, variantID);
        while ((serviceHolder = concurrentLinkedQueue.poll()) != null) {
            T serviceInstance = serviceHolder.get();
            if (serviceInstance == null) continue;
            return serviceInstance;
        }
        return null;
    }

    public void queueFreedUpService(final String pushMessageInformationId, final String variantID, T service, final ServiceDestroyer<T> destroyer) {
        ServiceDestroyer destroyAndReturnServiceSlot = new ServiceDestroyer<T>(){

            @Override
            public void destroy(T instance) {
                destroyer.destroy(instance);
                AbstractServiceHolder.this.returnServiceSlotToQueue(pushMessageInformationId, variantID);
            }
        };
        DisposableReference<T> disposableReference = new DisposableReference<T>(service, destroyAndReturnServiceSlot);
        this.serviceDisposalScheduler.scheduleForDisposal(disposableReference, this.serviceDisposalDelayInMillis);
        this.getCache(pushMessageInformationId, variantID).add(disposableReference);
    }

    public void freeUpSlot(String pushMessageInformationId, String variantID) {
        this.returnServiceSlotToQueue(pushMessageInformationId, variantID);
    }

    protected Object borrowServiceSlotFromQueue(String pushMessageInformationId, String variantID) {
        return this.jmsClient.receive().withSelector("variantID = '%s'", variantID).withTimeout(this.instanceAcquiringTimeoutInMillis).from((Destination)this.getFreeServiceSlotQueue());
    }

    protected void returnServiceSlotToQueue(String pushMessageInformationId, String variantID) {
        this.jmsClient.send((Serializable)((Object)(pushMessageInformationId + ":" + variantID))).withProperty("variantID", variantID).to((Destination)this.getFreeServiceSlotQueue());
    }

    private ConcurrentLinkedQueue<DisposableReference<T>> getCache(String pushMessageInformationId, String variantID) {
        return this.getOrCreateQueue(new Key(pushMessageInformationId, variantID));
    }

    private ConcurrentLinkedQueue<DisposableReference<T>> getOrCreateQueue(Key key) {
        ConcurrentLinkedQueue<DisposableReference<Object>> queue = this.queueMap.get(key);
        if (queue == null) {
            queue = this.queueMap.putIfAbsent(key, new ConcurrentLinkedQueue());
            queue = this.queueMap.get(key);
        }
        return queue;
    }

    private static class Key {
        private String pushMessageInformationId;
        private String variantId;

        Key(String pushMessageInformationId, String variantID) {
            if (pushMessageInformationId == null) {
                throw new NullPointerException("pushMessageInformationId");
            }
            if (variantID == null) {
                throw new NullPointerException("variant or its variantID cant be null");
            }
            this.pushMessageInformationId = pushMessageInformationId;
            this.variantId = variantID;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pushMessageInformationId == null ? 0 : this.pushMessageInformationId.hashCode());
            result = 31 * result + (this.variantId == null ? 0 : this.variantId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.pushMessageInformationId == null ? other.pushMessageInformationId != null : !this.pushMessageInformationId.equals(other.pushMessageInformationId)) {
                return false;
            }
            return !(this.variantId == null ? other.variantId != null : !this.variantId.equals(other.variantId));
        }
    }
}

