/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.serviceHolder;

import com.notnoop.apns.ApnsService;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.jms.Queue;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.event.VariantCompletedEvent;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithVariants;
import org.jboss.aerogear.unifiedpush.message.serviceHolder.AbstractServiceHolder;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ApnsServiceHolder
extends AbstractServiceHolder<ApnsService> {
    private final Logger logger = LoggerFactory.getLogger(ApnsServiceHolder.class);
    public static final int INSTANCE_LIMIT = 10;
    public static final long INSTANCE_ACQUIRING_TIMEOUT = 7500L;
    public static final long DISPOSING_DELAY = 5000L;
    @Inject
    private ClientInstallationService clientInstallationService;
    @Resource(mappedName="java:/queue/FreeServiceSlotQueue")
    private Queue freeServiceCounterQueue;

    public ApnsServiceHolder() {
        super(10, 7500L, 5000L);
    }

    @Override
    public Queue getFreeServiceSlotQueue() {
        return this.freeServiceCounterQueue;
    }

    public void initializeHolderForVariants(@Observes MessageHolderWithVariants msg) throws ExecutionException {
        if (msg.getVariantType() == VariantType.IOS) {
            msg.getVariants().forEach(variant -> this.initialize(msg.getPushMessageInformation().getId(), variant.getVariantID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUpAvailableServices(@Observes VariantCompletedEvent variantCompleted) throws ExecutionException {
        ApnsService service;
        String pushMessageInformationId = variantCompleted.getPushMessageInformationId();
        String variantID = variantCompleted.getVariantID();
        while ((service = (ApnsService)this.dequeue(pushMessageInformationId, variantID)) != null) {
            try {
                try {
                    Set<String> inactiveTokens = service.getInactiveDevices().keySet();
                    Set<String> transformedTokens = this.lowerCaseAllTokens(inactiveTokens);
                    if (!transformedTokens.isEmpty()) {
                        this.logger.info("Deleting '{}' inactive iOS installations", (Object)inactiveTokens.size());
                        this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(variantID, transformedTokens);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Unable to detect and delete inactive devices", (Throwable)e);
                }
                service.stop();
            }
            catch (Exception e) {
                this.logger.error("Unable to stop ApnsService", (Throwable)e);
            }
            finally {
                this.freeUpSlot(pushMessageInformationId, variantID);
            }
        }
        this.destroy(pushMessageInformationId, variantID);
    }

    private Set<String> lowerCaseAllTokens(Set<String> inactiveTokens) {
        return inactiveTokens.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }
}

