/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.serviceHolder;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.jboss.aerogear.unifiedpush.message.serviceHolder.DisposableReference;

@Singleton
@Startup
public class ServiceDisposalScheduler {
    private ScheduledExecutorService scheduler;
    private long terminationTimeout = 10000L;

    @PostConstruct
    public void initialize() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    @PreDestroy
    public void terminate() {
        try {
            this.scheduler.shutdown();
            this.scheduler.awaitTermination(this.terminationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted during attempt to shutdown gracefully", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForDisposal(DisposableReference<?> reference, long delay) {
        ScheduledExecutorService scheduledExecutorService = this.scheduler;
        synchronized (scheduledExecutorService) {
            this.terminationTimeout = Math.max(delay + 2500L, this.terminationTimeout);
            this.scheduler.schedule(new DisposeTask(reference), delay, TimeUnit.MILLISECONDS);
        }
    }

    private static class DisposeTask
    implements Runnable {
        private DisposableReference<?> reference;

        DisposeTask(DisposableReference<?> reference) {
            this.reference = reference;
        }

        @Override
        public void run() {
            this.reference.dispose();
        }
    }
}

