/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.token;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.jms.JMSException;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.dao.ResultStreamException;
import org.jboss.aerogear.unifiedpush.dao.ResultsStream;
import org.jboss.aerogear.unifiedpush.message.Criteria;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.configuration.SenderConfiguration;
import org.jboss.aerogear.unifiedpush.message.event.AllBatchesLoadedEvent;
import org.jboss.aerogear.unifiedpush.message.event.BatchLoadedEvent;
import org.jboss.aerogear.unifiedpush.message.event.TriggerVariantMetricCollectionEvent;
import org.jboss.aerogear.unifiedpush.message.exception.MessageDeliveryException;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithVariants;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.message.sender.SenderTypeLiteral;
import org.jboss.aerogear.unifiedpush.message.token.TokenLoaderUtils;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class TokenLoader {
    private final Logger logger = LoggerFactory.getLogger(TokenLoader.class);
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    @DispatchToQueue
    private Event<MessageHolderWithTokens> dispatchTokensEvent;
    @Inject
    @DispatchToQueue
    private Event<MessageHolderWithVariants> nextBatchEvent;
    @Inject
    @DispatchToQueue
    private Event<BatchLoadedEvent> batchLoaded;
    @Inject
    @DispatchToQueue
    private Event<AllBatchesLoadedEvent> allBatchesLoaded;
    @Inject
    @DispatchToQueue
    private Event<TriggerVariantMetricCollectionEvent> triggerVariantMetricCollection;
    @Inject
    @DispatchToQueue
    private Event<VariantMetricInformation> dispatchVariantMetricEvent;
    @Inject
    @Any
    private Instance<SenderConfiguration> senderConfiguration;
    @Resource
    private EJBContext context;

    public void loadAndQueueTokenBatch(@Observes @Dequeue MessageHolderWithVariants msg) throws IllegalStateException {
        UnifiedPushMessage message = msg.getUnifiedPushMessage();
        VariantType variantType = msg.getVariantType();
        Collection<Variant> variants = msg.getVariants();
        String lastTokenFromPreviousBatch = msg.getLastTokenFromPreviousBatch();
        SenderConfiguration configuration = (SenderConfiguration)this.senderConfiguration.select(new Annotation[]{new SenderTypeLiteral(variantType)}).get();
        PushMessageInformation pushMessageInformation = msg.getPushMessageInformation();
        int serialId = msg.getLastSerialId();
        this.logger.debug("Received message from queue: {}", (Object)message.getMessage().getAlert());
        Criteria criteria = message.getCriteria();
        List categories = criteria.getCategories();
        List aliases = criteria.getAliases();
        List deviceTypes = criteria.getDeviceTypes();
        this.logger.info(String.format("Preparing message delivery and loading tokens for the %s 3rd-party Push Network (for %d variants)", variantType, variants.size()));
        for (Variant variant : variants) {
            try {
                ResultsStream tokenStream;
                boolean gcmTopicRequest;
                TreeSet<String> topics = new TreeSet<String>();
                boolean isAndroid = variantType == VariantType.ANDROID;
                int batchesToLoad = configuration.batchesToLoad();
                boolean bl = gcmTopicRequest = isAndroid && TokenLoaderUtils.isGCMTopicRequest(criteria);
                if (gcmTopicRequest) {
                    if (serialId == 0) {
                        topics.addAll(TokenLoaderUtils.extractGCMTopics(criteria, variant.getVariantID()));
                        ++batchesToLoad;
                    }
                    tokenStream = this.clientInstallationService.findAllOldGoogleCloudMessagingDeviceTokenForVariantIDByCriteria(variant.getVariantID(), categories, aliases, deviceTypes, configuration.tokensToLoad(), lastTokenFromPreviousBatch).fetchSize(configuration.batchSize()).executeQuery();
                } else {
                    tokenStream = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(variant.getVariantID(), categories, aliases, deviceTypes, configuration.tokensToLoad(), lastTokenFromPreviousBatch).fetchSize(configuration.batchSize()).executeQuery();
                }
                String lastTokenInBatch = null;
                int tokensLoaded = 0;
                for (int batchNumber = 0; batchNumber < batchesToLoad; ++batchNumber) {
                    ++serialId;
                    TreeSet<String> tokens = new TreeSet<String>();
                    if (isAndroid && batchNumber == 0 && !topics.isEmpty()) {
                        tokens.addAll(topics);
                    } else {
                        for (int i = 0; i < configuration.batchSize() && tokenStream.next(); ++i) {
                            lastTokenInBatch = (String)tokenStream.get();
                            tokens.add(lastTokenInBatch);
                            ++tokensLoaded;
                        }
                    }
                    if (tokens.size() > 0) {
                        if (!this.tryToDispatchTokens(new MessageHolderWithTokens(msg.getPushMessageInformation(), message, variant, tokens, serialId))) {
                            this.logger.debug(String.format("Failing token loading transaction for batch token #%s for %s variant (%s), since queue is full, will retry...", serialId, variant.getType().getTypeName(), variant.getVariantID()));
                            this.context.setRollbackOnly();
                            return;
                        }
                        this.logger.info(String.format("Loaded batch #%s, containing %d tokens, for %s variant (%s)", serialId, tokens.size(), variant.getType().getTypeName(), variant.getVariantID()));
                        this.batchLoaded.fire((Object)new BatchLoadedEvent(variant.getVariantID() + ":" + msg.getPushMessageInformation().getId()));
                        if (serialId != 0) continue;
                        this.triggerVariantMetricCollection.fire((Object)new TriggerVariantMetricCollectionEvent(msg.getPushMessageInformation(), variant));
                        continue;
                    }
                    this.logger.debug(String.format("Ending batch processing: No more tokens for batch #%s available", serialId));
                    break;
                }
                if (tokensLoaded >= configuration.tokensToLoad()) {
                    this.logger.debug(String.format("Ending token loading transaction for %s variant (%s)", variant.getType().getTypeName(), variant.getVariantID()));
                    this.nextBatchEvent.fire((Object)new MessageHolderWithVariants(msg.getPushMessageInformation(), message, msg.getVariantType(), variants, serialId, lastTokenInBatch));
                    continue;
                }
                this.logger.debug(String.format("All batches for %s variant were loaded (%s)", variant.getType().getTypeName(), pushMessageInformation.getId()));
                this.allBatchesLoaded.fire((Object)new AllBatchesLoadedEvent(variant.getVariantID() + ":" + msg.getPushMessageInformation().getId()));
                this.triggerVariantMetricCollection.fire((Object)new TriggerVariantMetricCollectionEvent(pushMessageInformation, variant));
                if (tokensLoaded != 0 || lastTokenFromPreviousBatch != null) continue;
                if (gcmTopicRequest) {
                    this.logger.debug("No legacy(non-InstanceID) tokens found. Just pure GCM topic requests");
                } else {
                    this.logger.warn("Check your push query: Not a single token was loaded from the DB!");
                }
                VariantMetricInformation variantMetricInformation = new VariantMetricInformation();
                variantMetricInformation.setPushMessageInformation(msg.getPushMessageInformation());
                variantMetricInformation.setVariantID(variant.getVariantID());
                variantMetricInformation.setDeliveryStatus(Boolean.TRUE);
                this.dispatchVariantMetricEvent.fire((Object)variantMetricInformation);
            }
            catch (ResultStreamException e) {
                this.logger.error("Failed to load batch of tokens", (Throwable)e);
            }
        }
    }

    private boolean tryToDispatchTokens(MessageHolderWithTokens msg) {
        try {
            this.dispatchTokensEvent.fire((Object)msg);
            return true;
        }
        catch (MessageDeliveryException e) {
            Throwable cause = e.getCause();
            if (this.isQueueFullException(cause)) {
                return false;
            }
            throw e;
        }
    }

    private boolean isQueueFullException(Throwable e) {
        return e instanceof JMSException && e.getCause() != null && "ActiveMQAddressFullException".equals(e.getCause().getClass().getSimpleName());
    }
}

